/ low core

br4 = 200
br5 = 240
br6 = 300
br7 = 340

. = 0^.
	br	1f
	4

/ trap vectors
	trap; br7+0.		/ bus error
	trap; br7+1.		/ illegal instruction
	trap; br7+2.		/ bpt-trace trap
	trap; br7+3.		/ iot trap
	trap; br7+4.		/ power fail
	trap; br7+5.		/ emulator trap
	trap; br7+6.		/ system entry

. = 40^.
.globl	start, dump
1:	jmp	start
	jmp	dump


. = 60^.
	klin; br4
	klou; br4

. = 100^.
	kwlp; br6
	kwlp; br6

. = 114^.
	trap; br7+7.		/ 11/70 parity

. = 170^.
	rnin; br5+0.
	rnou; br5+0.

. = 220^.
	rkio; br5

. = 240^.
	trap; br7+7.		/ programmed interrupt
	trap; br7+8.		/ floating point
	trap; br7+9.		/ segmentation violation

. = 254^.
	rpio; br5

/ floating vectors
. = 300^.
	dcin; br4+0.
	dcou; br4+0.
	klin; br4+1.
	klou; br4+1.
	klin; br4+2.
	klou; br4+2.
	klin; br4+3
	klou; br4+3
	klin; br4+4
	klou; br4+4
	klin; br4+5.
	klou; br4+5.
	klin; br4+6.
	klou; br4+6.
	klin; br4+7.
	klou; br4+7.
	klin; br4+8.
	klou; br4+8.
	klin; br4+9.
	klou; br4+9.
	klin;	br4+10.
	klou;	br4+10.
	klin;	br4+11.
	klou;	br4+11.
	klin;	br4+12.
	klou;	br4+12.
	klin;	br4+13.
	klou;	br4+13.
	klin;	br4+14.
	klou;	br4+14.
	klin;	br4+15.
	klou;	br4+15.
. = 510^.
	lpin; br4
	lpou; br4
	lpin; br4+1
	lpou; br4+1

//////////////////////////////////////////////////////
/		interface code to C
//////////////////////////////////////////////////////

.globl	call, trap

.globl	_klrint
.globl _klin
_klin:
klin:	jsr	r0,call; _klrint
.globl	_klxint
.globl _klou
_klou:
klou:	jsr	r0,call; _klxint

.globl	_clock
kwlp:	jsr	r0,call; _clock


.globl	_rkintr
rkio:	jsr	r0,call; _rkintr

.globl	_dcrint
dcin:	jsr	r0,call; _dcrint
.globl	_dcxint
dcou:	jsr	r0,call; _dcxint

.globl _lprint
lpin:	jsr	r0,call; _lprint
.globl _lptint
lpou:	jsr	r0,call; _lptint
.globl _rpintr
rpio:	jsr	r0,call; _rpintr
.globl	_rnrint
rnin:	jsr	r0,call; _rnrint
.globl	_rntint
rnou:	jsr	r0,call; _rntint
