/*
 *	sys2.c
 *	file i/o sdyscalls
 */

#include "h\types.h"
#include "h\param.h"
#include "h\file.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\systm.h"

int rdwr (int,int,char*,int);
int open1 (struct inode*,int,int);


/*
 * read file
 */
read(fl,base,cnt)
int fl,cnt;
char *base;
	{
	return(rdwr(FREAD,fl,base,cnt));
	}

/*
 * write file
 */
write(fl,base,cnt)
int fl,cnt;
char *base;
	{
	return rdwr(FWRITE,fl,base,cnt);
	}

/*
 * common read-write
 */

rdwr(m,fl,base,cnt)
register int m;
int fl,cnt;
char *base;
	{
	register struct file *fp;
	fp=getf(fl);
	if(fp==0)
		return(0);
	if((fp->f_flag&m) ==0)
		{
		u->u_error=EBADF;
		return(0);
		}
	u->u_base = base;
	u->u_count=cnt;
	u->u_segflg=0;
	if(fp->f_flag&FPIPE)		/* pipe i/o is different	*/
		{
		if(m==FREAD)
			readp(fp);
		else
			writep(fp);
		}
	else
		{
		u->u_offset=fp->f_offset;
		if(m==FREAD)
			readi(fp->f_inode);
		else
			writei(fp->f_inode);
		fp->f_offset+=(cnt-u->u_count);
		}
	return(cnt-u->u_count);		/* returns bytes transferred	*/
	}

/*
 * open file
 */
#pragma warn -par	/* see comment in sys4.c	*/
open(n,m)
char *n;
int m;
	{
	register struct inode *ip;

printf("OPEN SYSCALL\n");
	ip=namei(uchar,0);
printf("Namei:%x\n",ip);
	if(ip==NULL)
		return(-1);
	m++;
	return open1(ip,m,0);
	}
/*
 * creat(e) file for write
 */
creat(n,m)
char *n; int m;
	{
	register struct inode *ip;

	ip=namei(uchar,1);
	if(ip==NULL)
		{
		if(u->u_error)
			return(-1);
		m&=~u->u_umask;
		ip=maknode(m&07777&(~ISVTX));
		if(ip==NULL)
			return(-1);
		return open1(ip,FWRITE,2);
		}
	else
		return open1(ip,FWRITE,1);
	}
/*
 * common open-creat
 */
open1(rip,m,trf)
register struct inode * rip;
int m;
int trf;
	{
	register struct file *fp;
	int i;
printf("open1\n");
	m&=(FREAD|FWRITE);
	if(trf!=2)
		{
		if (m&FREAD)
			access(rip,IREAD);
		if (m&FWRITE)
			{
			access(rip,IWRITE);
			if ((rip->i_mode&IFMT)==IFDIR)
				u->u_error=EISDIR;
			}
		}
		if(u->u_error)
			goto OUT;
printf("access\n");
		if(trf)
			itrunc(rip);
		prele(rip);
		if((fp=falloc())==NULL)
			goto OUT;
printf("falloc\n");
		fp->f_flag=m;
		fp->f_inode =rip;
		i=u->u_rv;
		openi(rip,m&FWRITE);
printf ("Open:%u %u\n",u->u_error,i);
		if(u->u_error==0)
			return(i);
		u->u_ofile[i]=NULL;
		fp->f_count--;
OUT:
		iput(rip);
		return(NULL);
		}

/*
 * close file
 */
void close(fl)
register int fl;
	{
	register struct file *fp;

	fp=getf(fl);
	if (fp==NULL)
		return;
	u->u_ofile[fl]=NULL;
	closef(fp);
	}
/*
 * umask default file creat mask
 */
umask(m)
	{
	register word um;

	um=u->u_umask;
	u->u_umask=m&0777;
	return(um);
	}
/*
 * seek original short seek
 */

offs_t seek(fl,p,t)
register int p;
int fl,t;
	{
	offs_t n;
	register struct file *fp;
	fp=getf(fl);
	if (fp==NULL)
		return(-1);
	if (fp->f_flag&FPIPE)		/* Can't seek a pipe	*/
		{
		u->u_error=ESPIPE;
		return(-1);
		}
	if (t>2)
		{
		n=(dword)p<<9;
		if(t==3)
			;
		}
	else
		{
		n=p;
		}
	switch(t)
		{
		case 1:
		case 4:
			n+=fp->f_offset;
			break;
		default:
			n+=I_SIZE(fp->f_inode);
		case 0:
		case 3: ;
		}
	return(fp->f_offset=n);
	}
/*
 * lseek long seek from system 7
 */
dword lseek(f,m,w)
long m;
	{
	offs_t l;
	register struct file *fp;

	fp=getf(f);
	if (fp==NULL)
		return(-1);
	if (fp->f_flag&FPIPE)
		{
		u->u_error=ESPIPE;
		return(-1);
		}
	switch(w&3)
		{
		case 0:	l=(dword)m;
			break;
		case 1: l=m+fp->f_offset;
			break;
		case 2: l=I_SIZE(fp->f_inode)+m;
			break;
		}
	return(fp->f_offset=l);
	}

/*
 * link
 */
link(n,l)
char *n,*l;
	{
	register struct inode *ip,*xp;

	ip=namei(uchar,0);
	if(ip==NULL)
		return(-1);
	if(ip->i_nlink>=127)
		{
		u->u_error=EMLINK;
		goto OUT;
		}
	if((ip->i_mode&IFMT)==IFDIR && !suser())  /* only su can link a dir*/
		goto OUT;

	ip->i_flag&=~ILOCK;
	u->u_dirp=l;
	xp=namei(uchar,1);
	if(xp!=NULL)
		{
		u->u_error=EEXIST;
		iput(xp);
		}
	if(u->u_error)
		goto OUT;
	if (u->u_pdir->i_dev != ip->i_dev)
		{
		iput(u->u_pdir);
		u->u_error = EXDEV;
		goto OUT;
		}
	wdir(ip);
	ip->i_nlink++;
	ip->i_flag |= IUPD;
OUT:
	iput(ip);
	return (0);
	}
/*
 * mknod
 */
void mknod(n,m,d)
	{
	register struct inode *ip;

	if(suser())
		{
		ip=namei(uchar,1);
		if(ip!=NULL)
			{
			u->u_error=EEXIST;
			goto OUT;
			}
		}
	if (u->u_error)
		return;
	ip = maknode(m);

	if (ip==NULL)
		return;
	ip->i_addr[0]=d;		/* dev number for spec files	*/
OUT:
	iput(ip);
	}

/*
 *	sleep syscall
 *	don't confuse with internal fn sleep
 */
void sslep(p1)
word p1;
	{
	time_t d;

	lock();
	d=time+p1;

	while (d>time)			/* tricky! tout stores the next	*/
		{			/* alarm time in the whole sys	*/
		if ((tout<=time) || (tout>d))
			{		/* every sleeper gets waken up	*/
			tout=d;		/* on tout, but only the ones	*/
			}		/* with expired sleep continues	*/
		sleep((int)&tout,PSLEP);
		}
	enable();
	}


