/* mch.s:  Machine language assist. */
/* 	Currently limit on physical memory is the size of the kernel	*/
/*	segment.  That is, 16MB.					*/


	.set	ROOTPTR,0x400		/* Hack.  boot strap problem */

	.set	ROUND, 511
	.set	GMASK, 0xfffffe00		/* truncate */
	.set	U_SIZE,3584
	.set	HIPRI,0x2700
	.set	LOPRI,0x2000
	.set	_u,0x04000000			/* u page address */
	.set	kernel,0x80000000		/* kernel space */
	.globl	_u
	.globl	_edata,_end
	.set	REGMASK,0xfefc
	.set	SP,48			/* offset into savearea of SP */
/*
 *	Subscripts into the segtable.  These also appear in seg.h.
 */

	.set	TEXTSEG,	0000
	.set	DATASEG,	0001
	.set	STACKSEG,	0002
	.set	MSGSEG,		0003
	.set	USEG, 		0004
	.set	KERNELSEG,	0200
	.set	KNOCACHE,	0201
	.set	IOSEG,		0377

	.data
	.globl	_maxmem,_locore
_maxmem:
	.long	0
_locore:
	.long	0

	.text
/*
 *	Start up code for kernel.
 * 	Notice that we are running in low core and must take care
 * 	not to mention addresses in the high space.
 */

	.globl	_start
_start:
	movw	#HIPRI,sr		/* supervisor state, ipl 7 */
	movl	#0x4e722700,0		/* stop on restart */
	movl	#0x80000000,d1		/* interrupt gets mapped */
	movl	d1,vb
	
	movl	#_end+ROUND,d0		/* top of unix */
	andl	#0x7ffffe00,d0		/* round up */
	movl	#_locore,d1
	andl	#0xffffff,d1		/* get real address, not fake */
	movl	d1, a0			/* going to use it as addr */
	movl	d0,a0@			/* usable mem starts at locore */
	movl	d0, d6			/* will use it later */
	addl	#U_SIZE,d0		/* proc 0 user area */

	movl	#_edata,a0		/* zero bss and u area */
	subl	#0x80000000,a0		/* use physical address */
	movl	#0,d7			/* constant zero */
1:
	movl	d7,a0@+			/* assumes edata is long aligned */
	cmpl	a0,d0
	bpl	1b			/* d0 - a0 is pos loop */

/*
 *	Setup mmu
 */
	movl	#256-1,d0		/* number of segment table entries */
	movl	#_segtable, a0		/* get address of segtable */
	subl	#0x80000000,a0		/* use phisical again */
	movl	a0, a1
1:
	clrl	a0@+
	clrl	a0@+
	dbra	d0, 1b			/* cleared table */

	/* set kernel address */

	movl	#0x7ffffd01, a1@(KERNELSEG<<3)
	clrl	a1@(KERNELSEG<<3+4)

	/* set kernel no cache address space */

	movl	#0x7ffffd41, a1@(KNOCACHE<<3)
	clrl	a1@(KNOCACHE<<3+4)

	/* set upage mapping */

	movl	#0x0007fd01, a1@(USEG<<3)
	movl	d6, a1@(USEG<<3+4)		/* map to this address */

	/* set io page */
	/* physical fffe0000 - ffffffff mapped one to one */

	movl	#0xff00fd41, a1@(IOSEG<<3)
	movl	#0xff000000, a1@(IOSEG<<3+4)

	/* vme 32 bit address space: fe000000 - feffffff */

	movl	#0x7ffffd41, a1@(0xfe<<3)
	movl	#0xfe000000, a1@(0xfe<<3+4)

	/* vme 32 bit address space: fd000000 - fdffffff */

	movl	#0x7ffffd41, a1@(0xfd<<3)
	movl	#0xfd000000, a1@(0xfd<<3+4)

	/* set user seg so we can continue to run here */

	movl	#0x7ffffd01, a1@(TEXTSEG<<3)
	movl	#0x00000000, a1@(TEXTSEG<<3+4)
	nop
	.word	0xf039		/* pmove root_ptr, crp */
	.word	0x4c00
	.long	ROOTPTR		/* hardcoded address */
	nop
	.word	0170071		/*	pmove	tc_proto, tc */
	.word	0040000
	.long	0x00000408
	nop
	nop
	nop
	nop		/* give it time to load */

	/* now running with the mmu on in the user text segment */

	jmp	1f			/* jump will use absolute address */
1:					/* now executing in kernel space */
	movl	#0x3919,d0
	.long	0x4e7b0002		/* movec d0, cac */
	movl	#_u+U_SIZE,sp		/* system stack at top of u area */
	jsr	_main			/* go do unix */
	subl	#64,sp
	clrw	sp@-			/* new procs return here */
	clrl	sp@-			/* set pc to beginning of user seg */
	clrw	sp@-			/* set sr to user mode */
	rte



/*
 *	User access routines are all similar.  Note the nofault that is used
 *	to catch request that have no memory for them.
 *
 * fubyte(addr) and fuibyte(addr)
 *	Same thing.
 */

	.globl	_fubyte, _fuibyte
_fubyte:
_fuibyte:
	movl	sp@(4),a0		/* get addr */
	movw	sr,sp@-			/* push old SR */
	movw	#HIPRI,sr		/* turn off interrupts */
	movl	nofault, sp@-		/* save the old nofault */
	movl	#err, nofault
	clrl	d0
	movb	a0@,d0			/* fetch byte */
	movl	sp@+, nofault
	movw	sp@+,sr			/* pop old sr */
	rts

/*
 *	fuword(addr) and fuiword(addr)
 */

	.globl	_fuword,_fuiword
_fuword:
_fuiword:
	movl	sp@(4),d0		/* get address */
	btst	#0,d0			/* check address odd */
	bne	aderr			/* oops */
	movl	d0,a0			/* set address */
	movw	sr,sp@-
	movw	#HIPRI,sr
	movl	nofault, sp@-
	movl	#err,nofault
	movl	a0@,d0
	movl	sp@+, nofault
	movw	sp@+,sr
	rts

/*
 *	subyte(addr, byte) and suibyte(addr, byte)
 */

	.globl	_subyte, _suibyte
_subyte:
_suibyte:
	movl	sp@(4),a0		/* addr */
	movl	sp@(8),d0		/* byte */
	movw	sr,sp@-
	movw	#HIPRI,sr
	movl	nofault, sp@-
	movl	#err,nofault
	movb	d0,a0@
	movl	sp@+, nofault
	movw	sp@+,sr
	movl	#0,d0
	rts

/*
 *	fuword(addr) and fuiword(addr)
 */

	.globl	_fushort, _fuishort
_fushort:
_fuishort:
	movl	sp@(4),d0		/* get address */
	btst	#0,d0			/* check address odd */
	bne	aderr			/* oops */
	movl	d0,a0			/* set address */
	movw	sr,sp@-
	movw	#HIPRI,sr
	movl	nofault, sp@-
	movl	#err,nofault
	movw	a0@,d0
	movl	sp@+, nofault
	movw	sp@+,sr
	rts

	.globl	_sushort
_sushort:
	movl	sp@(4),d0		/* address */
	btst	#0,d0
	bnes	aderr
	movl	d0, a0
	movl	sp@(8),d0		/* value */
	movw	sr,sp@-
	movw	#HIPRI, sr
	movl	nofault, sp@-
	movl	#err, nofault
	movw	d0,a0@
	movl	sp@+, nofault
	movw	sp@+, sr;
	movl	#0, d0
	rts

/*
 *	suword(addr, word) and suiword(addr, word)
 */

	.globl	_suword,_suiword
_suword:
_suiword:
	movl	sp@(4),d0		/* addr */
	btst	#0,d0
	bnes	aderr
	movl	d0,a0
	movl	sp@(8),d0
	movw	sr,sp@-
	movw	#HIPRI,sr
	movl	nofault, sp@-
	movl	#err,nofault
	movl	d0,a0@
	movl	sp@+, nofault
	movw	sp@+,sr
	movl	#0,d0
	rts

aderr:
	movl	#-1,d0
	rts

err:					/* fell off the face of the earth */
	movl	#-1,d0			/* BWC may not be right */
	movl	sp@+, nofault
	movw	sp@+,sr
	rts

	.data
	.globl	nofault
nofault:
	.long	0
	.text
	.globl	_addupc		/* inc user profile information */
_addupc:
	movl	sp@(8), a1	/* base of prof with base, leng, off, scale */
	movl	sp@(4), d0	/* pc */
	subl	a1@(8), d0	/* offset */
	lsrl	#1, d0		/* in words */
	movl	a1@(12), d1	/* get prof scale */
	lsrl	#1, d1
/*	mulu	d0, d1		/* scale */
	.word	046000		/* mulul	d0,d0:d1 */
	.word	012000		/* result is quad in d0:d1 */
	lsrl	#7, d1
	lsrl	#7, d1
	addl	#1, d1
	andl	#~1, d1		/* round up to word address */
	lsll	#7, d0
	lsll	#7, d0
	lsll	#3, d0
	orl	d0, d1		/* fold in high order part from quad */
	cmpl	a1@(4), d1
	bges	1f
	addl	a1@, d1		/* base */
	movl	sp@(12), d0
	movl	d1, a0
	movw	sr,sp@-			/* err might restore it */
	movl	nofault, sp@-
	movl	#2f, nofault
	addw	d0, a0@
	bra	3f
2:
	clrl	a1@(14)			/* turn off profiling */
3:
	movl	sp@+, nofault
	movw	sp@+, sr
1:
	rts
	
	rts
	.globl	_spl0, _splsoftclock, _splnet, _spltty, _splbio
	.globl	_splimp, _splclock, _splhigh, _splx
_spl0:
	movw	sr,d0
	movw	#0x2000,sr
	rts

_splsoftclock:
	movw	sr,d0
	movw	#0x2100,sr
	rts

_splnet:
	movw	sr,d0
	movw	#0x2200,sr
	rts

_spltty:
	movw	sr,d0
	movw	#0x2300,sr
	rts

_splbio:
	movw	sr,d0
	movw	#0x2400,sr
	rts

_splimp:
	movw	sr,d0
	movw	#0x2500,sr
	rts

_splclock:
	movw	sr,d0
	movw	#0x2600,sr
	rts

_splhigh:
	movw	sr,d0
	movw	#0x2700,sr
	rts

_splx:
	movw	sr,d0
	movw	sp@(6),sr
	rts


	.globl	_idle			/* what to do when nothing to do */
_idle:
	stop	#LOPRI
1:
	rts

	.data
	.globl	_waitloc
_waitloc:
	.long	1b
	.text

	.globl	_setjmp, _longjmp, _save, _resume

/*	setjmp(savearea) */

_setjmp:
_save:
	movl	sp@+,a1		/* pop return address of calling routine */
	movl	sp@,a0		/* address of save area */
	movml	#REGMASK,a0@	/* save a7-a1,d7-d2 */
	movl	#0,d0
	jmp	a1@


_longjmp:		/* (savearea) */
	movl	sp@(4),a0	/* get address of save area */
	movml	a0@,#REGMASK	/* restore d2-d7,a1-a7 */
	movl	#1,d0		/* always return 1 */
	jmp	a1@


_resume:			/* (paddr of _u, save area in _u) */
	movl	sp@(4),d0	/* pys addr of _u */
	movl	sp@(8),a0	/* save area */
	movw	sr,savesr
	movw	#HIPRI,sr	/* turn off interrupts */
	lsll	#8,d0		/* ctob(p_paddr) */
	lsll	#1,d0
	movl	d0, _segtable+(USEG<<3)+4	/* set upage register */
	.word	0xf000		/* pflusha */
	.word	0x2400
	movl	#3919, d0
	.long	0x4e7b0002	/* movec d0, cac */
	movml	a0@,#REGMASK	/* erotser registers */
	movw	savesr,sr	/* restore old status register */
	movl	#1,d0		/* return non zero */
	jmp	a1@


	.data
savesr:
	.long	0
	.text


	.globl	_copyseg		/* (from_click, to_click) */
_copyseg:
	movl	sp@(4),d0		/* from click */
	asll	#8,d0			/* convert to address */
	asll	#1,d0
	orl	#0x80000000,d0		/* we live in high mem */
	movl	d0,a1			/* and put into a pointer */
	movl	sp@(8),d0		/* to click */
	asll	#8,d0			/* d0 = ctob(to_click) */
	asll	#1,d0
	orl	#0x80000000,d0
	movl	d0,a0			/* and put that into a pointer */
	movl	#127,d0			/* do = # words to copy - 1 */
1:
	movl	a1@+,a0@+		/* copy a long */
	dbra	d0,1b			/* and loop */
	rts

	.globl	_clearseg		/* (click) */
_clearseg:
	movl	sp@(4),d0		/* get page number */
	asll	#8,d0
	asll	#1,d0
	orl	#0x80000000,d0		/* we live in high mem */
	movl	d0,a0
	movl	#127,d0		/* # of longs to clear - 1 */
1:
	clrl	a0@+
	dbra	d0,1b
	rts


	.globl	_copyin,_copyout
_copyin:
_copyout:
	movl	sp@(4),a0		/* from pointer */
	movl	sp@(8),a1		/* to pointer */
	movl	sp@(12),d0		/* number of bytes */
	beq	9f			/* do nothing if zero */
	movw	sr, sp@-
	movl	nofault, sp@-		/* arrange to catch bus errors */
	movl	#err,nofault

	bras	6f			/* test -- unaligned loop */

	movl	a0,d1			/* d1 = from */
	movl	a1,sp@-			/* I prefer regular */
	orl	sp@+, d1		/*   registers */
	andl	#03, d1			/* d1 = (from|to) & 03 */
	bnes	2f

6:
	movl	d0, d1			/* d1 = #bytes */
	lsrl	#2, d1			/* d1 = #bytes/sizeof (long) */
	beqs	7f			/* just bytes to copy */
	subl	#1, d1			/* d1 = (#bytes/sizeof (long) - 1 */
1:
	movl	a0@+, a1@+		/* move long at a time */
	dbra	d1, 1b		
	andl	#03, d0			/* d0 = left over count */
	bnes	7f			/* copy rest byte-at-a-time */
	bra	8f			/* all done */
2:					/* check for short aligned */
	andl	#01, d1			/* d1 = (from|to) & 01) */
	bnes	7f			/* no, do byte-at-a-time */
	movl	d0, d1			/* d1 = # bytes */
	lsrl	#1, d1			/* d1 = #bytes >> 1 */
	beqs	7f			/* no words */
	subl	#1, d1			/* figure number times thru loop */
1:
	movw	a0@+,a1@+		/* 2 bytes at a time */
	dbra	d1,1b
	andl	#1,d0			/* d0 = left over bytes */
	beqs	8f			/* if d0 == 0 then all done */
7:
	subl	#1, d0			/* loopcount = #bytes - 1 */
1:
	movb	a0@+, a1@+		/* single byte at a time */
	dbra	d0, 1b
8:
	movl	sp@+, nofault
	movw	sp@+, sr
9:
	movl	#0,d0
	rts

	.globl	rlrem,rldiv
rlrem:
	.word	046101
	.word	004001
	movl	d1,d0
	rts

rldiv:
	.word	046101
	.word	004001
	rts

	.globl	ruldiv	/* register unsigned long divide: d0 = d0 % d1. */
ruldiv:
	.word	046101		/* divul	d0,d1	q->d0, r->d1 */
	.word	000001		/* rem goes into d1 */
	rts

	.globl	rlmul
rlmul:
	.word	046001
	.word	004000
	rts
/* bcopy(from, to, size) */

_bcopy:	.globl	_bcopy
	movl	sp@(4),a0	/* source */
	movl	sp@(8),a1	/* destination */

	movw	a0,d0		/* check for one addr even & one addr odd */
	movw	a1,d1
	eorw	d1,d0
	andw	#1,d0

	movl	sp@(12),d1	/* count */

	cmpl	a0,a1		/* check for nasty overlap */
	jls	forward		/* no nasty overlap, copy in forward dir */
	addl	d1,a0		/* point a0 just past end of source string */
	cmpl	a0,a1		/* see if strings really overlap */
	jge	1f		/* no */
	addl	d1,a1		/* yes, point a1 just past end of dest string */
	jlt	backward	/* overlapping, must do backwards */

1:				/* no overlap */
	subl	d1,a0		/* point back at beginning of source string */

forward:
	cmpl	#8,d1		/* if less than 8 bytes just copy bytes */
	jlt	4f
	tstw	d0		/* if one addr even & one addr odd copy bytes */
	jne	4f

	movw	a0,d0		/* check for odd addrs */
	lsrw	#1,d0
	jcc	1f
	subql	#1,d1		/* both addrs odd, copy 1 byte */
	movb	a0@+,a1@+	/*  and then both addrs will be even */

1:				/* both addrs even, get ready to copy longs */
	movl	d1,d0		/* save byte count */
	lsrl	#2,d1		/* change to long count (truncated) */
	jra	3f		/* jump into long copy loop */

2:	movl	a0@+,a1@+	/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	2b

	movl	d0,d1		/* restore byte count */
	andl	#3,d1		/* 0-3 bytes left */
	jra	4f		/* jump into byte copy loop */

1:	movb	a0@+,a1@+	/* byte copy loop */
4:	dbf	d1,1b		/* entry point of byte copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	1b

	movq	#0,d0		/* tidy */
	rts

backward:
	cmpl	#8,d1		/* if less than 8 bytes just copy bytes */
	jlt	4f
	tstw	d0		/* if one addr even & one addr odd copy bytes */
	jne	4f

	movw	a0,d0		/* check for odd addrs */
	lsrw	#1,d0
	jcc	1f
	subql	#1,d1		/* both addrs odd, copy 1 byte */
	movb	a0@-,a1@-	/*  and then both addrs will be even */

1:				/* both addrs even, get ready to copy longs */
	movl	d1,d0		/* save byte count */
	lsrl	#2,d1		/* change to long count (truncated) */
	jra	3f		/* jump into long copy loop */

2:	movl	a0@-,a1@-	/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	2b

	movl	d0,d1		/* restore byte count */
	andl	#3,d1		/* 0-3 bytes left */
	jra	4f		/* jump into byte copy loop */

1:	movb	a0@-,a1@-	/* byte copy loop */
4:	dbf	d1,1b		/* entry point of byte copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jgt	1b

	movq	#0,d0		/* tidy */
	rts
/* bzero(base, length) */

_bzero:	.globl	_bzero
	movl	sp@(4),a0	/* base */
	movl	sp@(8),d1	/* length */
	jle	7f		/* ought to be positive */

	movw	a0,d0		/* check for odd address */
	lsrw	#1,d0
	jcc	1f
	clrb	a0@+
	subql	#1,d1
	jle	7f
1:				/* we now have even address, positive count */
	movq	#0,d0
	movl	d1,a1		/* save byte count */
	lsrl	#2,d1		/* convert to long count (truncated) */
	jra	3f

2:	movl	d0,a0@+		/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	2b
4:
	movw	a1,d1		/* restore byte count */
	andw	#3,d1		/* only interested in bottom 3 bits */
	jra	6f

5:	movb	d0,a0@+		/* copy last 0-3 bytes */
6:	dbf	d1,5b
7:
	rts

/*
 * Check sum routine used by the internet
 * check = cksum(buf, nbytes)
 */

	.globl	_cksum
_cksum:
	movl	sp@(8), d1
	movl	sp@(4), a0
	lsrl	#1,d1
	subl	#1,d1
	clrl	d0
1:
	addw	a0@+,d0
	bccs	2f
	addw	#1,d0
2:
	dbra	d1,1b
	notw	d0
	rts
