/* s.c */
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <sys/ethernet.h>
#include <sys/ipm.h>
#include "pep.h"
#include "malloc.h"

#define MTU 1518

extern int dbg;
extern int enfd;

send_conn() /*send a PEP_SET_TRID bcast*/
{
	char w[MTU];
	struct ether *ep;
	struct pephdr *pp;
	struct mesghdr mh; /* only to get size */
	u_short *dsp;

	ep = (struct ether *)w;
	pp = (struct pephdr *)(w + ETHERHLEN);
	dsp = (u_short *)(w + ETHERHLEN + PEPHLEN);
	memset(ep->dhost, 0xff, ETHERALEN);
	ep->type = PEP_ETYPE;
	pp->trid = 0;
	pp->type = PEP_SET_TRID;
	*dsp = getscope();
	etherwrite(w, ETHERHLEN + PEPHLEN + sizeof mh.dest.scope);

}

sendreply(wp)/*reply to a data packet*/
register char *wp;
{
	char neww[MTU];
        struct ether *oldep, *newep;
        struct pephdr *oldpp, *newpp;
	struct mesghdr mh; /* to get size */
	u_short *pidp;

	oldep = (struct ether *)wp;
	oldpp = (struct pephdr *)(wp + ETHERHLEN);
        newep = (struct ether *)neww;
        newpp = (struct pephdr *)(neww + ETHERHLEN);
	pidp = (u_short *)(neww + ETHERHLEN + PEPHLEN);
	memcpy(newep->dhost, oldep->shost, ETHERALEN);
	newep->type = oldep->type;
	newpp->trid = oldpp->trid;
	newpp->type = PEP_ACK;
	*pidp = *((u_short *)oldep + 2);
	etherwrite(neww, ETHERHLEN + PEPHLEN + sizeof mh.dest.scope);

}
int etherwrite(w, len)
register char *w;
int len;
{
	if(dbg) {
		fprintf(stderr, "pep:sent on enet:\n");
		hexdump(w, len);
	}
	if (write(enfd, w, len) < 0)
		perror("writing in etherwrite");
}
