#ifndef machine_h
#define machine_h
typedef unsigned int Address;
typedef unsigned char Byte;
typedef unsigned int Word;

# ifdef mc68000
#define NREG 17

#define ARGP 14		/* ARGP and FRP same on 68000's */
#define FRP 14
#define STKP 15
#define PROGCTR 16
# endif mc68000
# ifdef vax
#define NREG 16

#define ARGP 12
#define FRP 13
#define STKP 14
#define PROGCTR 15
# endif vax

#define BITSPERBYTE 8
#define BITSPERWORD (BITSPERBYTE * sizeof(Word))


#include "source.h"
#include "symbols.h"

Address pc;
Address prtaddr;

# define currlevel() ((whatblock(pc))->level)

Word nargspassed(/* frp */);
getmask(/* func,spoff */);
printinst(/* lowaddr, highaddr */);
printninst(/* count, addr */);
Address skip_frsetup(/* startaddr */);
Address printdata(/* lowaddr, highaddr, format */);
printndata(/* count, startaddr, format */);
printvalue(/* v, format */);
printerror(/*  */);
endprogram(/*  */);
stop_program(/*  */);
dostep(/* isnext */);
Address nextaddr(/* startaddr, isnext */);
setbp(/* addr */);
unsetbp(/* addr */);
Boolean isbperr(/*  */);
beginproc(/* p, argc */);
#endif machine_h
