/*
 *	print subroutine for 'p'
 *	This version does the '--' stuff
 */
# include <stdio.h>

# define QSIZE 10 * 1024
static char queue[QSIZE];
static char *front = queue;
static char *current = queue;
static char *next = queue;

qline(s)		/* stick 's' into queue */
	char *s;
{
	do {
		*next++ = *s++;
		if (next == &queue[QSIZE])
			next = queue;
		if (next == front) 
			rmline();
	} while (*(s-1));
	current = next;
}

static rmline()			/* chop off the first line in the queue */
{
	while (*front++) {
		if (front == &queue[QSIZE])
			front = queue;
	}
}

dqline(s)			/* dequeue a line from current */
	char *s;
{
	if (current == next)
		return 0;
	do {
		*s++ = *current++;
		if (current == &queue[QSIZE])
			current = queue;
	} while (*(s-1));
	return 1;
}

bkline(n)		/* backup current 'n' lines or first */
	int n;
{
	register char *cp;

	for (cp = current-1; cp != front && n > 0; cp--) {
		if (*cp == '\0')
			n--;
		if (cp == queue)
			cp = &queue[QSIZE];
	}
	current = cp;
}
