/*
 *  	sys4.c
 *
 *      misc syscalls
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\systm.h"
#include "h\inode.h"


/*
 *	get console switches on the PDP
 *	here: get kbd lock key
 */
getswit()
	{
	int swt;
	swt=inbyte(0x64);	/* kbd ctrl port	*/
	return(swt&16);		/* key lock bit		*/
	}
/*
 *	gtime: get current time
 */
long gtime()
	{
	return (time);
	}
/*
 *	stime: set current time only by su
 */
void stime(tm)
dword tm;
	{
	if (suser())
		{
		time=tm;
		wakeup ((int)&tout);
		}
	}

/*
 *	set user id by su or if reuid==new uid
 */
void setuid(uid)
register int uid;
	{
	register word uuid=uid&0xff;

	if (u->u_ruid==uuid || suser())
		{
		u->u_uid  =uuid;
		u->u_ruid =uuid;
		}
	}
/*
 *	get user id
 */
long getuid()
	{
	return((((dword)u->u_ruid)<<16)+u->u_uid);
	}
/*
 *	set group id
 */
void setgid(gid)
register int gid;
	{
	register word ugid=gid&0xff;
	if (u->u_rgid==ugid || suser())
		{
		u->u_gid  =ugid;
		u->u_rgid =ugid;
		}
	}
/*
 *	get group id
 */
long getgid()
	{
	return((((dword)u->u_rgid)<<16)+u->u_gid);
	}
/*
 *	get process id
 */
getpid()
	{
	return(cup->p_pid);
	}
/*
 *	nice for scheduling
 */
void nice(n)
register char n;
	{
	if (n>20)
		n=20;
	if (n<0 && !suser())	/* only su can increase	*/
		n=0;
	cup->p_nice=n;
	}
/*
 *	unlink file from fs
 */

#pragma warn -par	/* char *n is used by namei, but passed in trap.c*/
			/* and it stays on the stack.			 */
void unlink(n)
char *n;
	{
	register struct inode *ip,*pp;

	pp=namei(uchar,2);	/* get name for delete	*/
	if(pp==NULL)
		return;
	prele(pp);
	ip=iget(pp->i_dev,u->u_dent.u_ino);
	if(ip==NULL)
		panic("unlink--iget");

	if((ip->i_mode&IFMT)==IFDIR && !suser())
		goto OUT;	/* only su can unlink dir	*/

	u->u_offset-=DIRSIZ+2;
	u->u_base=(char*)&u->u_dent;
	u->u_count=DIRSIZ+2;
	u->u_dent.u_ino=0;
	writei(pp);          	/* write back zeroed entry	*/
	ip->i_nlink--;
	ip->i_flag|=IUPD;
OUT:
	iput(pp);
	iput(ip);
	}
/*
 *	change current directory
 */
void chdir(n)
char *n;
	{
	register struct inode *ip;

	ip=(struct inode*)namei(uchar,0);
	if(ip==NULL)
		return;
	if((ip->i_mode&IFMT)!=IFDIR)
		{
		u->u_error=ENOTDIR;
BAD:
		iput(ip);
		return;
		}
	if (access(ip,IEXEC))
		goto BAD;
	iput(u->u_cdir);
	u->u_cdir=ip;
	prele(ip);
	}
/*
 * change mode
 */
void chmod(n,m)
char *n;
register int m;
	{
	register struct inode *ip;

	if((ip=owner())==NULL)		/* only owner or su can chmod	*/
		return;
	ip->i_mode &= ~07777;
	if(u->u_uid)       		/* su can sticky		*/
		m&= ~ISVTX;
	ip->i_mode |= m&07777;
	ip->i_flag|=IUPD;
	iput(ip);
	}
/*
 * change owner
 */
void chown(n,o)
char *n;
register int o;
	{
	register struct inode *ip;

	if(!suser() || (ip=owner())==NULL)
		return;
	ip->i_uid = o&0xff;
	ip->i_gid = (o>>8)&0xff;
	ip->i_flag|=IUPD;
	iput(ip);
	}
/*
 * set modified date
 */
void smdate(n,d)
char *n;
time_t d;
	{
	register struct inode *ip;

	if((ip=owner())==NULL)
		return;
	ip->i_flag|=IUPD;
	iupdat(ip,d);
	iput(ip);
	}
/*
 * install signal handler
 */
ssig(a,s)
register a;
	{
	register rv;
	if (a<=0 || a>=NSIG || a==SIGKIL)
		{
		u->u_error=EINVAL;
		return(0);
		}
	rv=u->u_signal[a];
	u->u_signal[a]=s;
	if (cup->p_sig==a)
		cup->p_sig=0;
	return (rv);
	}
/*
 * send signal to process
 */
void kill(a,s)
register int a;
int s;
	{
	register struct proc *p;
	int f=0;

	for (p=&proc[0];p<&proc[NPROC];p++)
		{
		if (p==cup)
			continue;
		if (a!=0 && p->p_pid!=a)
			continue;
		if (a==0 &&(p->p_ttyp!=cup->p_ttyp || p<=&proc[1]))
			continue;
		if (u->u_uid!=0 && u->u_uid!=p->p_uid)
			continue;
		f++;
		psignal (p,s);
		}
	if (f==0)
		u->u_error=ESRCH;
	}

/*
 * get process times
 */
void times(t)
register word t;
	{
	register word *p;

	for (p=(word*)&u->u_utime;p<=(word*)&u->u_utime+6;)
		{
		suword(t,*p++);	/* copy out times from u struct	*/
		t+=2;
		}
	}
void profil(buf,siz,off,scal)
	{
	u->u_prof[0]=buf;
	u->u_prof[1]=siz;
	u->u_prof[2]=off;
	u->u_prof[3]=(scal>>1)&077777;
	}
/*
 * shutdown system
 */

void shdwn(m)
	{
	if (m==0)		/* flag means no sync	*/
		update();
	reboot();
/*NOTREACHED*/
	panic("Shutdown");
	}