#pragma inline
/*
 *	main.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\malloc.h"
#include "h\machine.h"
#include "h\inode.h"
#include "h\systm.h"

struct p_gen		{
			dword	text,data,stack0,stack;
			word	textl,datal,stack0l,stackl;
			word	ip,sp,sp0;
			};
void initkern(void);
void craftproc(void);
void gen_proc(int,struct p_gen*);

int kcode,kdata;
struct sys_desc	*gdt_beg;
struct sys_desc *idt_beg;
struct tss *hint0_tss;

endofc();

extern struct sys_desc kdesc1,kdesc2;

extern word stk0,stk1,stk2,stk3,stk0e,stk1e,stk2e,stk3e;
extern word frem;
extern byte endofd;

char kernelid[] = "UNIX V6 286 version by Szigeti Szabolcs\n";

void proc1();
void proc3();
void proc4();
void proc1()
	{
	user[0].u_prof[3]=0;
	enable();
	iinit();
	rootdir=(struct inode*)iget (rootdev,ROOTINO);
	rootdir->i_flag&=~ILOCK;
		if (((rootdir->i_mode&IFMT)&IFDIR)==0)
		panic("Rootdir");
	u->u_cdir=(struct inode*)iget(rootdev,ROOTINO);
	u->u_cdir->i_flag&=~ILOCK;
	mfree(coremap,1024L*63L,(dword)frem <<4);
//      mfree(coremap,384L*1024L,0x100000L);
	mfree(swapmap,2300L,2L);

	user[1].u_cdir=rootdir;//(struct inode*)iget(rootdev,ROOTINO);
	proc[1].p_stat=SRUN;
	proc[1].p_flag=SLOAD|SSYS;
#ifdef STANDSH
	user[2].u_cdir=rootdir;
	proc[2].p_stat=SRUN;
	proc[2].p_flag=SLOAD|SSYS;

#endif

	sched();
	panic ("proc0");
	}

void startk()
	{

	initkern();

	proc[0].p_ldt[TEXTS/8].rights=
		ACC_PRES|ACC_EXEC|ACC_READ|ACC_DATA|ACC_DPL0;
	proc[0].p_ldt[DATAS/8].rights=
		ACC_PRES|ACC_WRIT|ACC_DPL0|ACC_DATA;
	proc[0].p_ldt[STACKS/8].rights=
		ACC_PRES|ACC_WRIT|ACC_DOWN|ACC_DATA|ACC_DPL0;

	proc[0].p_ldt[TEXTS/8].limit  = (word)endofc;
	proc[0].p_ldt[DATAS/8].limit  = (word)&endofd;
	proc[0].p_ldt[STACKS/8].limit = (word)kstack[0];

	ldtfil(TEXTS,  ((dword)kcode)<<4,&proc[0]);
	ldtfil(DATAS,  ((dword)kdata)<<4,&proc[0]);
	ldtfil(STACKS, ((dword)kdata)<<4,&proc[0]);


	proc[0].p_tss.ax=proc[0].p_tss.bx=\
	proc[0].p_tss.cx=proc[0].p_tss.dx=\
	proc[0].p_tss.bp=proc[0].p_tss.si=proc[0].p_tss.di=0;

	proc[0].p_tss.ds=\
	proc[0].p_tss.es= DATAS  |SEL_TIL|SEL_RPL0;
	proc[0].p_tss.cs= TEXTS  |SEL_TIL|SEL_RPL0;
	proc[0].p_tss.ss= STACKS |SEL_TIL|SEL_RPL0;
	proc[0].p_tss.ss0=STACK0S|SEL_TIL|SEL_RPL0;

	proc[0].p_tss.sp=   (word)proc[0].p_kstck;
	proc[0].p_tss.ip=   (word)proc1;
	proc[0].p_tss.blink=0;
	proc[0].p_tss.flag= 512;        /* IT engedelyezve */

	proc[0].p_stat=SRUN;
	proc[0].p_pid =0;
	proc[0].p_pri =-127;
	proc[0].p_flag=SLOAD|SSYS;
	u=&user[0];
	u->u_prof[3]=0;
	craftproc();
	initdevices();
	cinit();
	binit();

	outbyte (IT1_MASK,~(1+2+4+/*8+16+*/32+64+128));
				/* clk,kbd,it2,com2,com1,lpt1,fdc,lpt2 */
	outbyte (IT2_MASK,~(64));
				/* hdc */
	enable();
	swtch();
	panic("START");
	}



void craftproc()     /*      Az indulo processzek letrehozasa kezzel */
	{
	struct p_gen p;

	p.text=((long)kcode)<<4;
	p.data=((long)kdata)<<4;
	p.stack=p.stack0=((long)kdata)<<4;
	p.textl=(word)endofc;
	p.datal=(word)&endofd;

	p.stackl=(word)0xffff;	/*&stk2e;*/
	p.ip=(word)proc3;
	p.sp=(word)&stk2;
	gen_proc(1,&p);
#ifdef STANDSH
	p.stackl=(word)0xffff;&stk3e;
	p.ip=(word)proc4;
	p.sp=(word)&stk3;
	gen_proc(2,&p);
#endif




	}
/*

	initkern(): a kernel belso valtozoinak es
		tablainak inicializalasa

									*/
void initkern()
	{
	register int i;

	outbyte(0x64,0xfd);     /* Gate A20                             */

	for (i=0;i<NPROC;i++)
		{
		fill_desc (U_TSK/8+i,kdata,(word)&(proc[i].p_tss));
		fill_desc (U_LDT/8+i,kdata,(word)&(proc[i].p_ldt));

		ldtfil (STACK0S,((dword)kdata<<4),&proc[i]);
		proc[i].p_ldt[STACK0S/8].limit=(word)kstack[i];
		proc[i].p_ldt[STACK0S/8].rights=\
			ACC_PRES|ACC_WRIT|ACC_DOWN|ACC_DATA|ACC_DPL0;

		proc[i].p_tss.sp0= (word)kstack[i]+KSSIZ-1;
		proc[i].p_kstck  = (word*)(kstack[i]+KSSIZ-1);
		proc[i].p_tss_sel= U_TSK+i*8;
		proc[i].p_tss.ldt= U_LDT+i*8;
		proc[i].p_tss.flag=512;
		proc[i].p_stat   = 0;
		proc[i].p_u      = &(user[i]);
		proc[i].p_u->u_umask=022;
		proc[i].p_u->u_prof[3]=0;
		}
	}
void fill_desc(no,seg86,off)
word no,seg86,off;
	{
	dword phys_addr;
	phys_addr=((dword)seg86<<4)+off;
	(gdt_beg+no)->base_l=(word)(phys_addr&0xffff);
	(gdt_beg+no)->base_h=(byte)(phys_addr>>16);
	}

/* gen_proc  :  process generalas
		A text es a data seg mar bent van a memoriaban, ezek
		cimet az ini structuraban magkapja a stack es ip
		kezdeti ertekevel       */
void gen_proc(slot,ini)
register int slot;
struct p_gen *ini;
	{
	register int i;

	proc[slot].p_ldt[TEXTS/8].rights=
		  ACC_PRES|ACC_EXEC|ACC_READ|ACC_DATA|ACC_DPL3;
	proc[slot].p_ldt[DATAS/8].rights=
		ACC_PRES|ACC_WRIT|ACC_DPL3|ACC_DATA;
	proc[slot].p_ldt[STACKS/8].rights=
		ACC_PRES|ACC_WRIT|ACC_DATA|ACC_DPL3;
	proc[slot].p_ldt[TEXTS/8].limit=ini->textl;
	proc[slot].p_ldt[DATAS/8].limit=ini->datal;
	proc[slot].p_ldt[STACKS/8].limit=ini->stackl;
	ldtfil(TEXTS,ini->text,&proc[slot]);
	ldtfil(DATAS,ini->data,&proc[slot]);
	ldtfil(STACKS,ini->stack,&proc[slot]);

	proc[slot].p_tss.ax=proc[slot].p_tss.bx=\
	proc[slot].p_tss.cx=proc[slot].p_tss.dx=\
	proc[slot].p_tss.bp=proc[slot].p_tss.si=proc[slot].p_tss.di=0;

	proc[slot].p_tss.ds=proc[slot].p_tss.es=DATAS|SEL_TIL|SEL_RPL3;
	proc[slot].p_tss.cs=TEXTS|SEL_TIL|SEL_RPL3;
	proc[slot].p_tss.ss=STACKS|SEL_TIL|SEL_RPL3;
	proc[slot].p_tss.ss0=STACK0S|SEL_TIL|SEL_RPL0;

	proc[slot].p_tss.sp=ini->sp;
	proc[slot].p_tss.ip=ini->ip;
	proc[slot].p_tss.blink=0;
	proc[slot].p_tss.flag=512;      /* IT engedelyezve */

	proc[slot].p_stat=0;
	proc[slot].p_flag=SLOAD;
	/*      Nem hasznalt pid-t keresunk az uj proc-nek  */
NOPID:  mpid++;
	for (i=1;i<=NPROC;i++)
		{
		if (proc[i].p_stat==0) continue;
		if (proc[i].p_pid==mpid) goto NOPID;
		}
	proc[slot].p_pid=mpid;
	}

void ldtfil(sel,addr,p)
register int sel;
register struct proc *p;
dword addr;
	{
	sel>>=3;
	p->p_ldt[sel].base_h=(byte)((addr>>16)&0xff);
	p->p_ldt[sel].base_l=(word)(addr&0xffff);
	}
estabur(nt,nd,ns,p)
word nt,nd,ns;
register struct proc *p;
	{
	p->p_ldt[TEXTS/8].limit=nt;
	p->p_ldt[DATAS/8].limit=(nd+ns);
	p->p_ldt[STACKS/8].limit=ns;
	return(0);
	}

word copyseg(a1,a2,n)
dword a1,a2;
word n;
	{
	kdesc1.limit=kdesc2.limit=n;
	kdesc1.base_h=(byte)((a1>>16)&0xff);
	kdesc1.base_l=(word)(a1&0xffff);
	kdesc2.base_h=(byte)((a2>>16)&0xff);
	kdesc2.base_l=(word)(a2&0xffff);

	asm {
		mov	cx,n
		cld
		push	si
		push	di
		push	ds
		push	es
		xor	si,si
		mov	di,si
		mov	ax,KSEL1
		mov	ds,ax
		mov	ax,KSEL2
		mov	es,ax
	rep     movsb
		pop	es
		pop	ds
		pop	di
		pop	si
		}               
	return(n);
	}
word clearseg(a,n)
dword a;
word n;
	{
	kdesc1.limit=n;
	kdesc1.base_h=(byte)((a>>16)&0xff);
	kdesc1.base_l=(word)(a&0xffff);

	asm {
		mov	cx,n
		cld
		push	di
		push	es
		xor	di,di
		mov	ax,KSEL1
		mov	es,ax
		mov	ax,di
	rep     stosb
		pop	es
		pop	di
		}
	return(n);
	}
#ifdef DEBUG
void dumpp()
	{
	register struct proc *rp;

	for(rp=&proc[0];rp<&proc[NPROC];rp++)
		{
		if (rp->p_stat)
			{
			printf("%u - %u/%x\n",rp->p_pid,rp->p_stat,
			rp->p_flag);
			}
		}
	}
#endif /* DEBUG */
