/*
 *	except.c
 *	(c) Szigeti Szabolcs 1992 mar 8
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\systm.h"

int excep (int,int);
void int_addr_e(word,word,word);
void int_addr  (word,word);
void exsig (int,int);


#define LOADKDSS()	lock();\
			asm mov ax,0x28;\
			asm mov ds,ax;\

#define RESTUDSS()   	asm mov ax,DATAS or SEL_TIL or SEL_RPL3;\
			asm mov ds,ax;\
			enable();

extern struct tss stf_tss;
extern struct tss int0_tss;
extern int updlock;
struct proc *cfpu;

void int_0()

	{
INT0:	printf("int0\n");
	if (excep(0,SIGFPT)==0) asm iret;
	asm iret;
	goto INT0;
	}

void int_1()

	{
INT1:	printf("int1\n");
	if (excep(1,SIGTRC)==0) asm iret;
	asm iret;
	goto INT1;
	}
void int_2()

	{
INT2:	printf("int2\n");
	if (excep(2,SIGBUS)==0) asm iret;
	asm iret;
	goto INT2;
	}
void int_3()

	{
INT3:	printf("int3\n");
	if (excep(3,SIGTRC)==0) asm iret;
	 asm iret;
	goto INT3;
	}
void int_4()

	{
INT4:	printf("int4\n");
	if (excep(4,SIGOVF )==0) asm iret;
	asm iret;
	goto INT4;
	}
void int_5()

	{
INT5:	printf("int5\n");
	if (excep(5,SIGBND)==0) asm iret;
	 asm iret;
	goto INT5;
	}
void int_6()

	{
INT6:	printf("int6\n");
	if (excep(6,SIGINS)==0) asm iret;
	 asm iret;
	goto INT6;
	}
void int_7()

	{
INT7:	printf("int7\n");
	if (excep(7,SIGFPT)==0) asm iret;
	 asm iret;
	goto INT7;
	}
void int_8()

	{
INT8:	printf("int8\n");
	if (excep(8,SIGBUS)==0) asm iret;
	 asm iret;
	goto INT8;
	}
void int_9()

	{
INT9:	printf("int9\n");
	if (excep(9,SIGFPT)==0) asm iret;
	asm iret;
	goto INT9;
	}
void int_10()

	{
INT10:	printf("int10\n");
	if (excep(10,SIGBUS)==0) asm iret;
	asm iret;
	goto INT10;
	}
void int_11()

	{
INT11:	printf("int11\n");
	if (excep(11,SIGSEG)==0) asm iret;
	asm iret;
	goto INT11;
	}
void int_12()
	{
	register word tsk;
	register struct tss *tss;
	static dword tssa;

STFT:	printf ("SigStack\n");
	tsk=(stf_tss.blink&~3)/8;
	tssa=(gdt_beg+tsk)->base_l+
		((dword)((gdt_beg+tsk)->base_h)<<16);
	tss=(struct tss*)(tssa-((dword)kdata<<4));
	tsk=tss->cs;
	if (tsk==0x18)
		{
		printf("Exception #12: Stack fault\n");
		printf("CS:%x  IP:%x\n",tss->cs,tss->ip);
		printf("SS:%x  SP:%x\n",tss->ss,tss->sp);
		panic("EXCEPTION");
		}
	psignal (cup,SIGSEG);
	if (issig())
		psig(4);
	 asm iret;
	goto STFT;
	}
void int_13()

	{

INT13:	lock();
	printf("int13 at %x\n",cup->p_tss.ip);
	if (excep(13,SIGSEG)==0) asm iret;
	asm iret;
	goto INT13;
	}
void int_16()

	{
INT16:	printf("int16\n");
	if (excep(16,SIGFPT)==0) asm iret;
	asm iret;
	goto INT16;
	}


void int_17(off,sel)
word off,sel;
	{
	LOADKDSS();
	if (sel==0x18)
		{
		printf("Exception #17: Unknown\n");
		int_addr(sel,off);
		panic("EXCEPTION");
		}
	exsig(SIGSEG,1);
	asm pop bp;
	 asm iret;	}
void int_18(off,sel)
word off,sel;
	{
	LOADKDSS();
	if (sel==0x18)
		{
		printf("Exception #18: Unknown\n");
		int_addr(sel,off);
		panic("EXCEPTION");
		}
	exsig(SIGSEG,1);
	asm pop bp;
	 asm iret;	}

void int_unexp(off,sel)
word off,sel;
	{
	LOADKDSS();
//	if (sel==0x18)
		{
		printf("Unexpected interrupt\n");
		int_addr(sel,off);
		panic("EXCEPTION");
		}
	}
void int_hunxp(off,sel)
word off,sel;
	{
	LOADKDSS();
//	if (sel==0x18)
		{
		printf("Unexpected hardware interrupt\n");
		int_addr(sel,off);
		panic("EXCEPTION");
		}
	}
void int_addr_e(sel,off,err)
word sel,off,err;
	{
	printf("Location: %x:%x with error code: %x\n",sel,off,err);
	}
void int_addr  (sel,off)
word sel,off;
	{
	printf("location: %x:%x\n",sel,off);
	}

void exsig (sig,tip)
	{
	psignal (cup,sig);
	if (issig())
		psig(tip);
	if (runrun)
		swtch();
	RESTUDSS();
	}
int excep(n,si)
int n,si;
	{
	register word tsk;
	register struct tss *tss;
	static dword tssa;
	extern int exit();

	tss=&int0_tss;
	tsk=(tss[n].blink&~3)/8;
	tssa=(gdt_beg+tsk)->base_l+((dword)((gdt_beg+tsk)->base_h)<<16);
	tss=(struct tss*)(tssa-((dword)kdata<<4));
	if (tss->cs==0x18)
		{
		printf("Kernel mode exception #%u\n",n);
		printf("At CS:%x  IP:%x\n",tss->cs,tss->ip);
		cup->p_tss.cs=0x18;
		cup->p_tss.ip=(word)panic;
		cup->p_tss.ss=cup->p_tss.ss0;
		cup->p_tss.sp=cup->p_tss.sp0;
		cup->p_tss.ds=0x28;
		return (0);
		}
	psignal(cup,si);
	if (issig())
		psig(5);
	if (runrun)
		swtch();
	return((int)tss);
	}
