/* stat.h : def of structure passed to stat & fstat syscall	*/

struct stat 
	{
	int	s_dev; 		/* device number	*/
	int	s_inumber;	/* i-node number	*/
	int	s_flags;	/* see below		*/
	char	s_nlinks;	/* number of links	*/
	char	s_uid;		/* owner user id	*/
	char	s_gid;		/* owner group id	*/
	char	s_size0;	/* file size high	*/
	int	s_size1;	/* file size low	*/
	int	s_addr[8];	/* block addr		*/
	long	s_actime;	/* accessed time	*/
	long	s_modtime;	/* modified time	*/
	};

/* flags */

#define S_ALLOC  0100000
#define S_TYPE   0060000	/* file type :		*/
#define S_PLAIN		0000000	/* plain file		*/
#define S_DIREC 	0040000	/* directory		*/
#define S_CHAR  	0020000	/* char special		*/
#define S_BLOCK		0060000	/* block special	*/
#define S_LARGE  0010000        /* file is large type	*/
#define S_SUID   0004000	/* set uid on exec	*/
#define	S_ISGID	 0002000	/* set gid on exec	*/
#define	S_ISVTX	 0001000	/* save swapped text	*/
#define	S_IREAD	 0000400	/* read permission, owner 		*/
#define	S_IWRITE 0000200	/* write permission, owner 		*/
#define	S_IEXEC	 0000100	/* execute/search permission, owner 	*/
