/*
 *	machine.h
 *	machine dependent constants
 */

#define DES_GDT		0x08
#define DES_IDT		0x10
#define DES_K_CODE	0x18
#define DES_ASTACK	0x20
#define DES_K_DATA	0x28
#define DES_VIDE_CO	0x30
#define DES_HINT_FIRST	0x40
#define DES_HSTC_FIRST	0x48
#define DES_HINT_TSK(x)	(gdt_beg+DES_HINT_FIRST/0x8+0x2*(x))
#define DES_HINT_STK(x)	(gdt_beg+DES_HSTC_FIRST/0x8+0x2*(x))
#define HINT_BLINK(x)	((hint0_tss+(x))->blink)

#define SC_SEL		0x150
#define U_LDT		0x250		/* Az elso user ldt desc */
#define U_TSK		(U_LDT+8*NPROC) /*   -   "  -   tss desc */
#define MEMSEL		(U_LDT+8*2*NPROC)
#define HDDSEL1		(MEMSEL+8)
#define HDDSEL2		(HDDSEL1+8)
#define KSEL1		(HDDSEL2+8)
#define KSEL2		(KSEL1+8)
#define KSEL3		(KSEL2+8)
#define KSEL4		(KSEL3+8)

#define intack1() outbyte (0x20,0x20)	/* 1.it vez nyugtazas	*/
#define intack2() outbyte (0xa0,0x20)   /* 2.   -   "   -	*/
#define IRET	asm iret;		/* return from interrupt*/

#define TIMERC		0x43
#define TIMER0		0x40
#define	TIMER1		0x41
#define TIMER2		0x42
#define TIMERFREQ	1193182L
#define	TIMER0MOD	0x36	/* ch.0; load all; mode 3; binary */
#define TIMER2MOD	0xf6	/* ch.2; load all; mode 3; binary */

#define VIDHORTOT	0
#define VIDHORDIS	1
#define VIDHSYNPOS	2
#define VIDHSYNWID	3
#define VIDVERTOT	4
#define VIDVERTADJ	5
#define VIDVERDIS	6
#define VIDSYNPOS	7
#define VIDINTER	8
#define VIDMAXSCN	9
#define VIDCSTART	10
#define VIDCEND		11
#define VIDADDRH	12
#define VIDADDRL        13
#define VIDCADDH	14
#define VIDCADDL	15
#define VIDLPH		16
#define VIDLPL		17

#define	CMOSADDR	0x70
#define CMOSDATA	0x71
#define	CMOSRSEC	0
#define CMOSASEC	1
#define CMOSRMIN	2
#define CMOSAMIN	3
#define CMOSRHOR	4
#define CMOSAHOR	5
#define CMOSWDAY	6
#define CMOSMDAY	7
#define CMOSMONT	8
#define CMOSYEAR	9
#define CMOSASTS	10
#define CMOSBSTS	11
#define CMOSCSTS	12
#define CMOSDSTS	13

#define CMOSFLOPPY	0x10
#define		FLONONE	0
#define		FLO360	1
#define		FLO12	2
#define		FLO720	3
#define		FLO144	4

#define	VIDCA		0x3d4
#define	VIDCD		0x3d5
#define	VIDCM		0x3d8
#define	VIDCC		0x3d9
#define	VIDCS		0x3da

#define IO_PPI		0x61
#define SPK_ON		3
#define SPK_OFF		0

#define IT1_MASK	0x21
#define IT2_MASK	0xa1