/*
 * Debugger information structures.
 * Debug segment is sequence of symbols.
 */

#ifndef	DEBUG_H
#define	DEBUG_H	DEBUG_H

#include <reloc.h>
#include <ltype.h>

/*
 * The debug segment of a relocatable file is a collection of symbols,
 * possibly spread over several fragments,
 * with relocation applied to the values of relocatable symbols.
 * These symbols form a number (usually one) of source file symbol blocks.
 *
 * A symbol block consists of a symbol having a local symbol table
 * (source file, function, struct type, union type, enum type etc.)
 * then a begin symbol
 * followed by a list of local symbols and (recursively defined) symbol blocks,
 * terminated by an end symbol.
 *
 * A source file symbol has the name of the source file,
 * the address of the first executable statement,
 * and type "source file".
 *
 * A begin symbol
 * has name "{", the address of the first executable statement,
 * and type containing a dbst_t structure in a numeric type node.
 *
 * An end symbol has name "}", the address just past the last executable code,
 * and type as for a begin symbol.
 *
 * A source statement symbol has name ";", the address of the corresponding
 * executable code, and type as for a begin symbol.
 *
 * Local symbols on the stack have seg L_STACK;
 * parameters have seg P_STACK;
 * the address is the offset (in bytes) from the frame pointer.
 * Register class symbols have seg L_REG and address identifying
 * the register (machine dependent).
 *
 * Struct and union members have seg FLD_OFF;
 * the address is offset in bits.
 *
 * Enum members have seg ABSLUTE; address is numeric value.
 *
 * Type strings conform to same syntax as loader type strings;
 * all references to named types are represented by name strings.
 * Type symbols (seg TYPESYM) define these names in terms of loader types.
 */

#define	P_STACK	(SUMMARY+1)
#define	L_STACK	(SUMMARY+2)
#define	L_REG	(SUMMARY+3)
#define	FLD_OFF	(SUMMARY+4)

typedef	struct	dbst_t	{		/* structure in type string for stat */
	unsigned short	db_line;	/* line number */
	unsigned char	db_col,		/* column number */
			db_flag;	/* flags internal to debugger */
	unsigned short	db_code;	/* saved instruction code */
} dbst_t;

#endif
