/* sid.h: ADAPTIVE interprocess communications */
/*
 * Free mesg structures are on a free list.
 * Unallocated sid structures have serv_id's of zero.
 */


struct	mesg	{		/* like buf */
	struct	mesg	*next;	/* linked */
	struct	mesghdr	header;	/* header from user */
	caddr_t		addr;	/* address of data */
	short		size;	/* in clicks */
	short		pid;	/* sending process */
};

struct	sid	{			/* service identifiers */
	struct	sid	*next;		/* liked */
	struct	proc	*rsel;		/* who is waiting for read select */
	struct	proc	*wsel;		/* who is waiting for write select */
	struct	sidq	{
		struct	mesg	*first;
		struct	mesg	*last;
	} norm, import;			/* the queues */
	sid_t		serv_id;	/* this service id */
	short		flag;		/* for select flags */
	int		count;		/* # of msgs placed on queue */
};

/* flags */
#define	RSELSID	001	/* read select collision */
#define	WSELSID	002	/* write seelct collision */

extern	struct	sid	sid[];
extern	struct	mesg	mesg[];
