/* udp_user.h:  definition for user programs using udp */

typedef	unsigned long udp_port;

struct	udpaddr	{
	in_addr		host;
	udp_port	port;
};

struct	udpuser	{
	int		code;
	udp_port	lport, fport;
	in_addr		laddr, faddr;
};

#define	UDPC_LISTEN		1
#define	UDPC_CONNECT		2
#define	UDPC_OK			3
#define	UDPC_SORRY		4
#define	UDPC_BADDEV		5
#define	UDPC_BADLOCAL		7
#define	UDPC_BOUND		8
#define	UDPC_DATAGRAM		9

struct	udp	{
	short	sport;		/* source UPD port number */
	short	dport;		/* destination port number */
	short	udplen;		/* length of udp header */
	short	ucksum;		/* UDP checksum (0 => no checksum) */
	char	data[2];	/* data starts here */
};
