/*
 *	sig.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\inode.h"
#include "h\systm.h"

void sig1(int);
void stop(void);
int procxmt(void);
int core (void);
void exit(void);
int psuword(char*,word,struct proc*);

#define IPCPRI	(-1)
struct
	{
	int	ip_lock;
	int	ip_req;
	int	ip_addr;
	int	ip_data;
	} ipc;
extern struct tss stf_tss;

/*
 * send signnal to every process with controlling tty tp
 */
void signal (tp,sig)
int tp,sig;
	{
	register struct proc *p;

	for (p=&proc[0];p<&proc[NPROC];p++)
		if (p->p_ttyp==tp)
			psignal (p,sig);
	}

/*
 * send signal to process
 */

void psignal (p,sig)
register struct proc *p;
int sig;
	{
	if (sig>=NSIG)
		return;
	if (p->p_sig!=SIGKIL)
		p->p_sig=sig;
	if (p->p_pri>PUSER)
		p->p_pri=PUSER;
	if (p->p_stat==SWAIT)
		setrun (p);
	}

/*
 * give number of pending signal
 */

issig()
	{
	register int n;
	register struct proc *p;

	p=cup;
#pragma warn -pia
	if (n=p->p_sig)
#pragma warn +pia
		{
		if (p->p_flag&STRC)
			{
			stop();
			if ((n=p->p_sig)==0)
				return(0);
			}
		if (u->u_signal[n]!=1)
			return(n);
		}
	return(0);
	}

/*
 * tracing
 */
void stop(void)
	{
	register struct proc *pp,*cp;
LOOP:
	cp=cup;
	if (cp->p_ppid!=1)
	for (pp=&proc[0];pp<&proc[NPROC];pp++)
		if (pp->p_pid==cp->p_ppid)
			{
			wakeup((int)pp);
			cp->p_stat=SSTOP;
			swtch();
			if ((cp->p_flag&STRC)==0 || procxmt())
				return;
			goto LOOP;
			}
		exit();
	}
/*
 * handle signal
 */
void psig(w)
int w;
	{
	register struct proc *rp;
	register int n;
	int p;

	rp=cup;
	n=rp->p_sig;
	rp->p_sig=0;
#ifdef DEBUG
printf("Signo:%u pid:%u at %x\n",n,cup->p_pid,cup->p_tss.ip);
#endif DEBUG
	if((p=u->u_signal[n])!=0)
		{
		u->u_error=0;
		if (n!=SIGINS && n!=SIGTRC)
			u->u_signal[n]=0;
		switch (w)
			{
			case 0:		/* signal in syscall 		*/
	suword(*(cup->p_kstck-2)+10,*(cup->p_kstck-9));
	*(cup->p_kstck-2)-=2;
	*(cup->p_kstck-9)=p;
	break;
			case 5:		/* signal in exception		*/
			case 3:		/* siganl in clock		*/
	psuword((char*)(cup->p_tss.sp-=2),cup->p_tss.ip,cup);
	cup->p_tss.ip=p;
	break;
			case 4:		/* signal in stack fault	*/
	if(psuword((char*)(cup->p_tss.sp-=2),cup->p_tss.ip,cup)==-1)
		{
		printf ("Stack fault in %u\n",cup->p_pid);
		goto DEAD;		/* cannot continue		*/
		}
	cup->p_tss.ip=p;
	break;

			default: panic("Psig");
			}
		return;
		}
DEAD:	if (w==0)		/* from here process wil continue at	*/
		sig1(n);	/* sig1, no matter from where psig was	*/
	cup->p_tss.ip=(word)sig1;	/* called			*/
	cup->p_tss.cs=0x18;
	cup->p_tss.ds=0x28;
	cup->p_tss.ss=STACK0S|SEL_TIL;
	cup->p_tss.sp=(word)cup->p_kstck-30;
	*(cup->p_kstck-29)=n;
	}
void sig1(n)
	{
	switch(n)
		{
		case SIGQIT:
		case SIGINS:
		case SIGTRC:
		case SIGIOT:
		case SIGFPT:
		case SIGSEG:
		case SIGSYS:
			u->u_rv=n;
			if (core())
				n+=0200;
			else
				{
#ifdef DEBUG
				printf("Cannot dump core:%u\n",u->u_error);
#endif /* DEBUG */
				;
				}
		}
	u->u_rv=(u->u_rv<<8)|n;
	exit();
	}
/*
 * dump core
 */
int core ()
	{
	register int s;
	register struct inode *ip;
	extern schar();

#ifdef NO_CORE_DUMP
	printf ("Core dump disabled\n");
	return (0);
#else
	u->u_error=0;
	u->u_dirp="core";
	ip=namei(schar,1);
	if (ip==NULL)
		{
		if (u->u_error)
			return(0);
		ip=maknode(0666);
		if(ip==NULL)
			return(0);
		}
	if (!access(ip,IWRITE) && (ip->i_mode&IFMT)==0 &&
		u->u_uid==u->u_ruid)
		{
		itrunc(ip);
		u->u_offset=0;
		u->u_base=(char*)u;
		u->u_count=sizeof(struct user);
		u->u_segflg=1;
		writei(ip);
		s=cup->p_size;
		u->u_base=0;
		u->u_count=s;
		u->u_segflg=0;
		writei(ip);
		}
	iput(ip);
	return(u->u_error==0);
#endif /* NO_CORE_DUMP */
	}

int psuword(b,w,p)
word w;
char *b;
struct proc *p;
	{
	register word lim;
	extern struct sys_desc kdesc3;
	if((lim=p->p_ldt[DATAS/8].limit)<(word)b)
		return(-1);
	kdesc3.base_h=p->p_ldt[DATAS/8].base_h;
	kdesc3.base_l=p->p_ldt[DATAS/8].base_l;
	kdesc3.limit =lim;
	asm {
		push	ds
		mov	ax,KSEL3
		mov	ds,ax
		mov	bx,b
		mov	ax,w
		mov	[bx],ax
		pop	ds
	    }
	return(0);
	}

/*
 * ptrace syscall
 */
ptrace(re,pi,ad,da)
	{
	register struct proc *p;

	if (re<=0)
		{
		cup->p_flag|=STRC;
		return(0);
		}
	for (p=proc;p<&proc[NPROC];p++)
		if (p->p_stat==SSTOP &&
		    p->p_pid==pi &&
		    p->p_ppid==cup->p_pid)
			goto FOUND;
	u->u_error=ESRCH;
	return(0);
FOUND:
	while (ipc.ip_lock)
		sleep((int)&ipc,IPCPRI);
	ipc.ip_lock=p->p_pid;
	ipc.ip_data=da;
	ipc.ip_addr=ad;
	ipc.ip_req =re;
	p->p_flag&=~SWTED;
	setrun(p);
	while(ipc.ip_req>0)
		sleep((int)&ipc,IPCPRI);
	if (ipc.ip_req<0)
		u->u_error=EIO;
	ipc.ip_lock=0;
	wakeup((int)&ipc);
	return(ipc.ip_data);
	}

int procxmt(void)
	{
	register int i;
#ifdef notyet
	register int *p;
#endif

	if (ipc.ip_lock != cup->p_pid)
		return(0);
	i=ipc.ip_req;
	ipc.ip_req=0;
	wakeup ((int)&ipc);
	switch(i)
		{
	case 1:
	case 2:
		if (fubyte(ipc.ip_addr)==-1)
			goto ERROR;
		ipc.ip_data=fuword(ipc.ip_addr);
		break;
	default:
	ERROR:
		ipc.ip_req =-1;
		}
	return(0);
	}