/*	sys.c
 *	indirect driver for controlling tty
 *
 *	(c) AT&T
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\conf.h"
#include "h\tty.h"
#include "h\systm.h"

#define MAJOR 1

struct tty *syttyp()
	{
	register struct tty *tp;

	tp = cup->p_ttyp;
	if(tp == NULL)
		u->u_error = ENXIO;
	return(tp);
	}

syopen(dev, flag)
	{
	register struct tty *tp;

	if(tp = syttyp())
	(*cdevsw[major(tp->t_dev)].d_open)(tp->t_dev, flag);
	}

syclose(dev, flag)
	{
	register struct tty *tp;

	if(tp = syttyp())
	(*cdevsw[major(tp->t_dev)].d_close)(tp->t_dev, flag);
	}

syread(dev)
	{
	register struct tty*tp;

	if(tp = syttyp())
	(*cdevsw[major(tp->t_dev)].d_read)(tp->t_dev);
	}

sywrite(dev)
	{
	register struct tty*tp;

	if(tp = syttyp())
	(*cdevsw[major(tp->t_dev)].d_write)(tp->t_dev);
	}

sysgtty(dev, flag)
int *flag;
	{
	register struct tty*tp;

	if(tp = syttyp())
	(*cdevsw[major(tp->t_dev)].d_sgtty)(tp->t_dev, flag);
	}
