/*
 *	 bio.c
 *  Common block device routines
 *
 *	(c) AT&T
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\buf.h"
#include "h\conf.h"
#include "h\systm.h"

struct buf* incore (dev_t,blk_t);

struct buf buf[NBUF];

struct buf swbuf;

char buffers [NBUF][512];

struct buf bfreelist;

blk_t rablock;
int nblkdev;

/*
 * Get the specified block from the device
 */

struct buf* getblk(dev,blkno)
dev_t dev;
blk_t blkno;
	{
	register struct buf *bp;
	register struct devtab *dp;
	word save;

	if (major(dev)>=nblkdev)
		panic("BLKDEV");

LOOP:	if (dev<0)
		dp=(struct devtab*)&bfreelist;
	else
		{
		dp=bdevsw[major(dev)].d_tab;
		if (dp==NULL)
			panic ("DEVTAB");

		for (bp=dp->b_forw; bp!=(struct buf*)dp ;bp=bp->b_forw)
			{
			if (bp->b_blkno!=blkno || bp->b_dev!=dev)
				continue;
			save=lock1();
			if (bp->b_flags&B_BUSY)
				{
				bp->b_flags|=B_WANTED;
				sleep ((int)bp,PRIBIO);
				unlock(save);
				goto LOOP;
				}
			unlock(save);
			notavail(bp);

			return(bp);
			}
		}
		save=lock1();
		if (bfreelist.av_forw==&bfreelist)
			{
			bfreelist.b_flags|=B_WANTED;
			sleep((int)&bfreelist,PRIBIO);
			unlock(save);
			goto LOOP;
			}
		unlock(save);
		notavail(bp=bfreelist.av_forw);
		if (bp->b_flags&B_DELWRI)
			{
			bp->b_flags|=B_ASYNC;
			bwrite(bp);
			goto LOOP;
			}
		bp->b_flags=B_BUSY|B_RELOC;
		bp->b_back->b_forw=bp->b_forw;
		bp->b_forw->b_back=bp->b_back;
		bp->b_forw=dp->b_forw;
		bp->b_back=(struct buf*)dp;
		dp->b_forw->b_back=bp;
		dp->b_forw=bp;
		bp->b_dev=dev;
		bp->b_blkno=blkno;

		return(bp);
	}

/*
 *	read in a block, if not already in core
 */

struct buf* bread(dev,blkno)
dev_t dev;
blk_t blkno;
	{
	register struct buf *rbp;

	rbp=(struct buf *)getblk(dev,blkno);
	if (rbp->b_flags&B_DONE)		/* is in core	*/
		return(rbp);
	rbp->b_flags|=B_READ;
	rbp->b_wcount=-256;
	(*bdevsw[major(dev)].d_strategy)(rbp);
	iowait(rbp);
	return(rbp);
	}

/*
 *	read in one block, and start read on another
 */

struct buf* breada(dev,blkno,rablkno)
dev_t dev;
blk_t blkno,rablkno;
	{
	register struct buf *rbp,*rabp;

	rbp=NULL;
	if (!incore(dev,blkno))
		{
		rbp=getblk(dev,blkno);
		if ((rbp->b_flags&B_DONE)==0)
			{
			rbp->b_flags|=B_READ;
			rbp->b_wcount=-256;
			(*bdevsw[major(dev)].d_strategy)(rbp);
			}
		}
	if(rablkno&&!incore(dev,rablkno))
		{
		rabp=getblk(dev,rablkno);
		if (rabp->b_flags&B_DONE)
			brelse(rabp);
		else
			{
			rabp->b_flags|=B_READ|B_ASYNC;
			rabp->b_wcount=-256;
			(*bdevsw[major(dev)].d_strategy)(rabp);
			}
		}
	if(rbp==0)
		return(bread(dev,blkno));
	iowait(rbp);
	return(rbp);
	}

/*
 * write out  one block and release
 */

void bwrite(rbp)
register struct buf *rbp;
	{
	register int flag;

	flag=rbp->b_flags;
	rbp->b_flags&=~(B_READ|B_DONE|B_ERROR|B_DELWRI);
	rbp->b_wcount=-256;
	(*bdevsw[major(rbp->b_dev)].d_strategy)(rbp);
	if ((flag&B_ASYNC)==0)
		{
		iowait(rbp);
		brelse(rbp);
		}
	else
		if ((flag&B_DELWRI)==0)
			geterror(rbp);
	}

/*
 *	realease buffer, mark it to write out at next use
 */

void bdwrite(rbp)
register struct buf *rbp;
	{

	rbp->b_flags|=B_DELWRI|B_DONE;
	brelse(rbp);
	}

/*
 * release buffer and start write on it
 */
void bawrite(rbp)
register struct buf *rbp;
	{
	rbp->b_flags|=B_ASYNC;
	bwrite(rbp);
	}

/*
 * release buffer without i/o
 */
void brelse(rbp)

register struct buf *rbp;
	{
	register struct buf **backp;
	word save;

	if (rbp->b_flags&B_WANTED)
		wakeup((int)rbp);
	if (bfreelist.b_flags&B_WANTED)
		{
		bfreelist.b_flags&=~B_WANTED;
		wakeup((int)&bfreelist);
		}
	if (rbp->b_flags&B_ERROR)
		{
		rbp->b_dev|=0xff;
		}
	backp=&bfreelist.av_back;
	save=lock1();
	rbp->b_flags&=~(B_WANTED|B_BUSY|B_ASYNC);
	(*backp)->av_forw=rbp;
	rbp->av_back=*backp;
	*backp=rbp;
	rbp->av_forw=&bfreelist;
	unlock(save);
	}

/*
 * see if block is in core
 */

struct buf*incore(dev,blkno)
dev_t dev;
blk_t blkno;
	{
	register struct buf *bp;
	register struct devtab *dp;

	dp=bdevsw[major(dev)].d_tab;
	for (bp=dp->b_forw;bp!=(struct buf*)dp;bp=bp->b_forw)
		if (bp->b_blkno==blkno && bp->b_dev==dev)
			return(bp);
	return(0);
	}

/*
 * wait for i/o to finish
 */

void iowait(rbp)
register struct buf *rbp;
	{
	register word save;

	save=lock1();
	while ((rbp->b_flags&B_DONE)==0)
		sleep((int)rbp,PRIBIO);
	unlock(save);
	geterror(rbp);
	}

/*
 *	get buffer out of the free list
 */

void notavail(rbp)
register struct buf *rbp;
	{
	register word save;

	save=lock1();
	rbp->av_back->av_forw=rbp->av_forw;
	rbp->av_forw->av_back=rbp->av_back;
	rbp->b_flags|=B_BUSY;
	unlock(save);
	}

/*
 * mark buffer ready
 */

void iodone(rbp)
register struct buf *rbp;
	{
	rbp->b_flags|=B_DONE;
	if (rbp->b_flags&B_ASYNC)
		brelse(rbp);
	else
		{
		rbp->b_flags&=~B_WANTED;
		wakeup((int)rbp);
		}
	}

/*
 * clear buffer
 */
void clrbuf(bp)
struct buf *bp;
	{
	register int *p;
	register int c;

	p=(int *)bp->b_addr;
	c=256;
	do
		*p++=0;
	while(--c);
	}

/*
 * initialize buffer handling
 */

void binit()
	{
	register struct buf *bp;
	register int i;
	struct devtab *dp;
	struct bdevsw *bdp;
	struct buf *bad;
	dword addr;

	bfreelist.b_forw=bfreelist.b_back=bfreelist.av_forw=bfreelist.av_back
		=&bfreelist;
	for (i=0;i<NBUF;i++)
		{
		bp=&buf[i];
		bp->b_dev=-1;
		bp->b_addr=buffers[i];
		bp->b_xmem=(dword)kdata<<4;
		bp->b_back=&bfreelist;
		bp->b_forw=bfreelist.b_forw;
		bfreelist.b_forw->b_back=bp;
		bfreelist.b_forw=bp;
		bp->b_flags=B_BUSY;
		addr=bp->b_xmem+(word)bp->b_addr;

		if(((addr>>16)&0xff)!=(((addr+512-1)>>16)&0xff))
			{
			printf ("Buffer %u. on DMA boundary!\n",i);
			bad=bp;
			}
			brelse(bp);
		}
		if (bad) notavail (bad);
	i=0;
	for (bdp=bdevsw;bdp->d_open;bdp++)
		{
		dp=(struct devtab *)bdp->d_tab;
		if (dp)
			{
			dp->b_forw=(struct buf *)dp;
			dp->b_back=(struct buf *)dp;
			}
		i++;
		}
	nblkdev=i;
	}

/*
 * write every modified buffer
 */

void bflush(dev)
int dev;
	{
	register struct buf *bp;
	register word save;
LOOP:
	save=lock1();
	for (bp=bfreelist.av_forw;bp!=&bfreelist;bp=bp->av_forw)
		{
		if (bp->b_flags&B_DELWRI&&(dev==NODEV||dev==bp->b_dev))
			{
			bp->b_flags|=B_ASYNC;
			notavail(bp);
			bwrite(bp);
			goto LOOP;
			}
		}
	unlock(save);
	}

/*
 * get error code from i/o
 */

void geterror(bp)
register struct buf *bp;
	{
	if (bp->b_flags&B_ERROR)
		if ((u->u_error=bp->b_error)==0)
			u->u_error=EIO;
	}
/*
 * swap to/from memory
 */
#ifndef NOSWAP
swap(blkno,coreaddr,count,rdflg)
blk_t blkno;
word count;
gaddr_t coreaddr;
int rdflg;
	{
	register int *fp;
	register word save;
if (count==0) return(0);
	fp=&swbuf.b_flags;
	save=lock1();
	while(*fp&B_BUSY)
		{
		*fp|=B_WANTED;
		sleep((int)fp,PSWP);
		}
	*fp=B_BUSY|B_PHYS|rdflg;
	swbuf.b_dev=swapdev;
	swbuf.b_wcount=-((count+1)/2);
	swbuf.b_blkno=blkno;
	swbuf.b_addr=(char *)(coreaddr&0xffff);
	swbuf.b_xmem=(dword)(coreaddr&0xffff0000L);
	(*bdevsw[major(swapdev)].d_strategy)(&swbuf);
	lock();

	while((*fp&B_DONE)==0)
		sleep((int)fp,PSWP);
	if (*fp&B_WANTED)
		wakeup((int)fp);
	unlock(save);
	*fp&=~(B_BUSY|B_WANTED);
#ifdef DEBUG
	if (*fp&B_ERROR)
	printf("swap blk error\n");
#endif /*DEBUG*/
	return(*fp&B_ERROR);
	}
#endif /* NOSWAP */
/*
 * direct i/o
 */
void physio(strat,bp,dev,rw)
register struct buf *bp;
int (*strat)();
dev_t dev;
	{
	register char *base;
	word save;

	base=u->u_base;
	if (((dword)(word)base+(dword)u->u_count) > cup->p_ldt[DATAS/8].limit)
		{
		u->u_error=EFAULT;
		return;
		}
	save=lock1();
	while (bp->b_flags&B_BUSY)
		{
		bp->b_flags|=B_WANTED;
		sleep((int)bp,PRIBIO);
		}
	bp->b_flags=B_BUSY|B_PHYS|rw;
	bp->b_dev=dev;
	bp->b_addr=base;
	bp->b_xmem=((dword)cup->p_ldt[DATAS/8].base_h<<16)+
		    cup->p_ldt[DATAS/8].base_l;
	bp->b_blkno=(blk_t)(u->u_offset>>9);
	bp->b_wcount= -((u->u_count>>1)&0xffff);
	bp->b_error=0;
	cup->p_flag|=SLOCK;
	(*strat)(bp);
	lock();
	while((bp->b_flags&B_DONE)==0)
		sleep((int)bp,PRIBIO);
	cup->p_flag&=~SLOCK;
	if (bp->b_flags&B_WANTED)
		wakeup((int)bp);
	unlock(save);
	bp->b_flags&=~(B_BUSY|B_WANTED);
	u->u_count=(-bp->b_resid)<<1;
	geterror(bp);
	}

