/*
	## exe2v6 ##

		MSDOS exe file konvertalo UNIX V6 formatumra

	A UNIX vegrehajthato file szerkezete:

	Offset 0: 
		  fejlec: w0: magic number 0407/0410/0411
			  w1: text szegmens merete 
			  w2: data szegmens merete 
			  w3: bss szegmens merete 
			  w4: stack merete
			  w6: ip kezdeti erteke
			  w7-w8: 0
	Offset 16: 
		  text seg
		  data seg
									*/

#include <stdio.h>
#include <string.h>
#include "h\exe2unix.h"

void quit(int);
int process(void);

char *errls[]=
	{
	"OK",
	"Bad map",
	"Header read fault",
	"Not exe",
	"Header write fault",
	"Text read fault",
	"Text write fault",
	"Data read fault",
	"Data write fault",
	"No stack"
	};
struct unix_head 	u_head;
struct msdos_head 	d_head;	
unsigned long 		dstart;
char lnbuf[108];
FILE  *ef,*df,*mf;	/* exe file, unix file, map file */

void main(argc,argv)
int argc;
char *argv[];
	{
	char *ex;
	int b;
	if (argc!=2)
		{
		fprintf(stderr,"Bad args.\n");
		quit(1);
		}
	strcpy (lnbuf,argv[1]);
	ex=&lnbuf[strlen(lnbuf)];
	*ex++='.';
	strcpy (ex,"exe\0");
	filop (&ef,"rb");
	strcpy (ex,"uni\0");
	filop (&df,"wb");
	strcpy (ex,"map\0");
	filop (&mf,"r");
	if ((b=process())!=NULL)
		{
		ex++;
		fprintf(stderr,"Processing fault:%s.\n",errls[b]);
		quit(3);
		}
	quit(0);
	}
filop(fil,mod)
FILE **fil;
char *mod;
	{
	if ((*fil=fopen(lnbuf,mod))==NULL)
		{
		fprintf(stderr,"File open error.\n");
		quit(2);
		}
	}

void quit(rv)
int rv;
	{
	if (ef) fclose (ef);
	if (df) fclose (df);
	if (mf)	fclose (mf);
	exit (rv);
	}
int getseg(nam,seg)
char *nam;
int seg[3];
	{
	char *np,segnam[40];
	fseek(mf,0L,SEEK_SET);
	while(fgets(lnbuf,81,mf))
		{
		sscanf(lnbuf,"%xH %xH %xH %s",&seg[0],&seg[1],&seg[2],segnam);
		if((np=strchr(segnam,' '))!=NULL)
			*np='\0';
		
		if (strcmp(nam,segnam)==NULL)
			{
			return(0);
			}

		}

	return(-1);
	}
int getdst()
	{
	unsigned int se,of;
	char nam[30],*np;
	fseek(mf,0L,SEEK_SET);
	while(fgets(lnbuf,81,mf))
		{
		sscanf(lnbuf,"%x:%x       %s",&se,&of,nam);
		if((np=strchr(nam,' '))!=NULL)
			*np='\0';
		if (strcmp(nam,"__DATASTART")==NULL)
			{
			dstart=((unsigned long)se<<4)+of;
			printf("Ds:%lx\n",dstart);
			return(0);
			}
		}
	return(-1);
	}
int process()
	{
	unsigned int sg[3][3];
	unsigned long cop;
	unsigned int i;
	char padding;
	static char in;

	if(getseg("_TEXT",sg[0])||
	   getseg("_DATA",sg[1])||
	   getseg("_BSS",sg[2]))
		return(1);
	if (getdst())
		return(9);
	if(fread(&d_head,sizeof(d_head),1,ef)!=1)
		return(2);
	if(d_head.exesig!='MZ')
		return(3);
	padding=sg[1][0]&0xf;
	u_head.magic=0411;
	u_head.tssiz=sg[0][2];
	u_head.sssiz=dstart-sg[1][0];
	u_head.dssiz=sg[1][2]+padding-u_head.sssiz;
	u_head.bssiz=sg[2][2];
	u_head.initip=d_head.exeip;
printf("T:%x D:%x B:%x S:%x\n",u_head.tssiz,u_head.dssiz,u_head.bssiz,
	u_head.sssiz);
	if(fwrite(&u_head,sizeof(u_head),1,df)!=1)
		return(4);

	cop=d_head.hdrsize*16+sg[0][0];
	fseek(ef,cop,SEEK_SET);
	for(i=0;i<u_head.tssiz;i++)
		{
		if(fread(&in,1,1,ef)!=1)
			return(5);
		if(fwrite(&in,1,1,df)!=1)
			return(6);
		}
	while(padding--)
		fputc(0,df);
	cop=d_head.hdrsize*16+sg[1][0]+u_head.sssiz;
	fseek(ef,cop,SEEK_SET);
	for(i=0;i<u_head.dssiz;i++)
		{
		if(fread(&in,1,1,ef)!=1)
			return(7);
		if(fwrite(&in,1,1,df)!=1)
			return(8);
		}
	return(0);
	}