/*	## CO.H	##
	(c) Szigeti Szabolcs 2 apr 1992

	IBM AT 102 gombos billentyuzet include
									*/


/*******	8042 I/O cimek			******/
	
#define KBDAT	0x60			/* Billentyuzet adat	*/
#define KBCTL	0x64			/* Billentyuzet vezerlo	*/

/*******	8042 status reg. bitek olvasas	******/

#define KR_EPAR		128		/* Paritas hiba		*/
#define KR_RECTO	64		/* Vetel Time-out	*/
#define KR_TRATO	32		/* Adas Time-out	*/
#define KR_NLOCK	16		/* Bill. nincs lezarva	*/
#define KR_COMM		8		/* Parancs/adat 	*/
#define KR_FLAG		4		/* Self-test OK		*/
#define KR_IBF		2		/* Bemeneti puffer teli	*/
#define KR_OBF		1		/* Kimeneti puffer teli	*/

/*******	8042 status reg. bitek iras	******/

#define KW_PCCOM	64		/* PC kompatibilis mod	*/
#define KW_PCMOD	32		/* PC interface mod	*/
#define KW_INHIB	16		/* Interface tiltas	*/
#define KW_UNLOC	8		/* Tiltas feluliras	*/
#define KW_FLAG		4		/* KR_FLAG irasa`	*/
#define KW_INTR		1		/* Megszkitas engedely	*/

/*******	8042 parancsok			******/

#define KC_READCOM	0x20		/* parancs kiolvasasa	*/
#define KC_WRITEST	0x60		/* 8042 status irasa	*/
#define KC_SELFTST	0xaa		/* onteszt		*/
#define KC_IFTEST	0xab		/* interface teszt	*/
#define KC_DIAG		0xac
#define KC_LOCK		0xad		/* bill. tiltas		*/
#define KC_UNLOCK	0xad		/* bill. engedelyezes	*/
#define KC_READINP	0xc0
#define KC_READOUP	0xd0
#define KC_WRITOUP	0xd1
#define KC_READTES	0xe0
#define KC_IMPULS	0xf0

/*******	8042 bemeneti port		******/

#define KI_KEYKEY	128		/* Bill. kulcs 0=zarva	*/
#define KI_MONTYP	64		/* Monitor 0=colour	*/
#define KI_FJUMP	32
#define KI_MBRAM	16

/*******	8042 kimeneti port		******/

#define KO_KDATA	128
#define KO_KCLOCK	64
#define KO_IBF		32
#define KO_OBF          16
#define KO_A20GATE	2		/* A20 kapuzas		*/
#define KO_SYSRESET	1		/* Hideg reset		*/


/*******	Billenyuzet parancsok		******/

#define	KB_RESET	0xff
#define KB_RESEND	0xfe
#define	KB_SETDEF	0xf6
#define KB_DEFDIS	0xf5
#define KB_ENABLE	0xf4		/* Engedelyezes		*/
#define KB_SETRATE	0xf3
#define KB_ECHO		0xee
#define KB_SETIND	0xed
#define KB_SELSCAN	0xf0		/* Scan code tabla 	*/
#define KB_READID	0xf2
#define	KB_ALLTM	0xf7
#define KB_ALLMB	0xf8
#define KB_ALLM		0xf9
#define KB_ALLTMB	0xfa
#define KB_SETT		0xfb    	/* Typematic tipus	*/
#define KB_SETB		0xfc		/* Make/Break tipus	*/
#define KB_SETM		0xfd		/* Make tipus		*/

#define LED_SCROLL	128
#define LED_NUM		64
#define LED_CAPS	32

/********	Billentyuzet uzenetek		******/

#define KK_RESEND	0xfe
#define KK_ACK		0xfa  		/* Acknowledge kod	*/
#define KK_OVERRUN	0x00		/* Puffer tulfutas	*/
#define KK_DIAGERR	0xfd		/* Diagnosztikai hiba	*/
#define KK_BRPREF	0xf0		/* Break prefix		*/
#define KK_BATOK	0xaa		/* BAT hibatlan		*/
#define KK_ECHO		0xee
#define KK_KDERROR	0xff
#define KK_KEYID	0x83ab          /* 102 gombos ID	*/
#define KK_BATFAIL	0xfc		/* BAT sikertelen	*/

/*******	Fontos scan kodok		******/

#define SC_CAPSL	0x14
#define SC_NUML		0x76
#define SC_SCRL		0x5F
#define SC_LSHF		0x12
#define SC_LCTR		0x11
#define SC_LALT		0x19
#define SC_RSHF		0x59
#define SC_RCTR		0x39
#define SC_RALT		0x58

/*******	Makrok				******/



struct	{
	byte scan;
	byte type;
	}
	keymode[]=
	{
		{0x57,KB_SETM},
		{0x5F,KB_SETM},
		{0x62,KB_SETM},
		{0x67,KB_SETM},
		{0x6E,KB_SETM},
		{0x65,KB_SETM},
		{0x76,KB_SETM},
		{0x14,KB_SETM},
		{0x12,KB_SETB},
		{0x59,KB_SETB},
		{0x11,KB_SETB},
		{0x19,KB_SETB},
		{0x39,KB_SETB},
		{0x58,KB_SETB},
		{0,0}
	};
