/*
 * Random set of variables used by more than one routine.
 */
char	canonb[CANBSIZ];	/* buffer for erase and kill */
struct inode *rootdir;	/* pointer to inode of root directory */
time_t lbolt;		/* time in HZ since last boot */
time_t time;		/* time in sec from 1970 */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch.  It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major device numbers.
 */

int 	nblkdev;

/* 
 * Number of character switch entries.
 * Set by cinit/tty.c
 */

int 	nchrdev;

char runin;		/* scheduling flag */
char runout;		/* scheduling flag */
char runrun;		/* scheduling flag */
char curpri;		/* current priority */
struct proc *runq;	/* head of linked list of running processes */

int	maxmem;			/* max available memory */
daddr_t	swplo;		/* block number of swap space */
daddr_t	dumplo;		/* block offset into dev for unix core dump */
int	nswap;			/* size of swap space */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
dev_t rootdev;		/* device of the root */
dev_t swapdev;		/* swapping device */
dev_t pipedev;		/* pipe device */
dev_t dumpdev;		/* unix core dump device */
char *panicstr;		/* panic string pointer */
extern	short icode[];		/* user init code */
extern	int	szicode;	/* its size */

dev_t getmdev();
daddr_t	bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *geteblk();
struct buf *bread();
struct buf *breada();
struct filsys *getfs();
struct file *getf();
struct file *falloc();
int	uchar();

/*
 * Instrumentation
 */

int	dk_busy;
long	dk_time[32];
long	dk_numb[3];
long	dk_wds[3];
long	tk_nin;
long	tk_nout;

/*
 * Structure of the system-entry table
 */
extern struct sysent {
	char	sy_narg;		/* total number of arguments */
	char	sy_nrarg;		/* number of args in registers */
	int	(*sy_call)();		/* handler */
} sysent[];

char	msgbuf[MSGBUFS];	/* saved printf characters */
