/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */
struct	file
{
	char		f_flag;
	cnt_t		f_count;	/* reference count */
	union	{
		struct	inode *F_inode;
		struct	sid	*F_sid;
	} U;
	off_t		f_offset;	/* read/write character pointer */
};

#define	f_inode	U.F_inode
#define	f_sid	U.F_sid

extern struct file file[];	/* The file table itself */

/* flags */
#define	FREAD	00001
#define	FWRITE	00002
#define	FPIPE	00004
#define	FSID	00010
#define	FAPPEND	00020
