#include <stdio.h>
#include <sys/inet/in.h>

main()
{
	struct in_service *sp;
	in_addr a = (134<<24)|(56<<16)|(34<<8)|76;	/* in /etc/hosts */
	in_addr b = (1<<24)|(2<<16)|(3<<8)|(4);		/* not in file */

	printf ("0x%x => in_ntoa => '%s'\n", (int) a, in_ntoa(a));
	printf ("host name for that is '%s'\n", in_host(a));
	printf ("I don't know who '%s' is\n", in_host(b));
	printf ("in_address of 'me' is %s\n", in_ntoa(in_address("me")));
	printf ("in_address of 'hal' is %s\n", in_ntoa(in_address("hal")));
	sp = in_service(NULL, NULL, 0);
	printf ("first item in services is %s/%s/%d\n", sp->name, sp->proto,
		sp->port);
	sp = in_service(NULL, "udp", 0);
	printf ("first udp service is %s/%s/%d\n", sp->name, sp->proto, sp->port);
	sp = in_service(NULL, "tcp", 512);
	printf ("tcp 512 is %s/%s/%d\n", sp->name, sp->proto, sp->port);
	sp = in_service("shell", NULL, 0);
	printf ("to use shell I need %s/%s/%d\n", sp->name, sp->proto, sp->port);
	sp = in_service("Brantley", "not there", 9911);
	printf ("in_service(junk) returned %d\n", sp);
}
