/* route.c: Manipulate routing tables */
#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/inet/in.h>
#include <sys/inio.h>
#include <sys/inet/ip_var.h>

#define	IPDEV "/dev/ip3"
int	ipfd;

char	*usage = "usage:%s [add|delete] dest [gateway]\n";
char	*progname;

main(argc, argv)
	int argc;
	char *argv[];
{
	progname = argv[0];
	ipfd = ipopen();
	if (argc < 3)
		prusage();
	if (strcmp(argv[1], "add") == 0)
		add(argc, argv);
	else if (strcmp(argv[1], "delete") == 0)
		delete(argc, argv);
	else
		prusage();
	close(ipfd);
}

add(argc, argv)	/* add a route to the table */
	int argc;
	char *argv[];
{
	struct route route;

	if (argc != 4)
		prusage();
	if ((route.dst = in_address(argv[2])) == 0)
		error("unknown system %s\n", argv[2]);
	if ((route.gate = in_address(argv[3])) == 0)
		error("unknown system %s\n", argv[3]);
	eioctl(ipfd, IPIOROUTE, &route);
}


delete(argc, argv)	/* remove a route from the table */
	int argc;
	char *argv[];
{
	struct route route;

	if ((route.dst = in_address(argv[2])) == 0)
		error("unknown host '%s'\n", argv[2]);
	route.gate = 0;
	eioctl(ipfd, IPIODROUTE, (char *)&route);
}

prusage()
{
	fprintf(stderr, usage, progname);
	exit(1);
}

ipopen()
{
	int fd;

	if ((fd = open(IPDEV, 2)) == -1)
		error("Can't open %s", IPDEV);
	return fd;
}

error(fmt)
	char *fmt;
{
	va_list args;

	va_start(args, fmt);
	fprintf(stderr, "%s: ", progname);
	vfprintf(stderr, fmt, args);
	va_end(args);
	exit(1);
}

eioctl(fd, cmd, arg)
	int fd;
	char *cmd, *arg;
{
	int r;

	if ((r = ioctl(fd, cmd, arg)) == -1)
		error("ioctl cmd %x failed\n", cmd);
	return r;
}
