/* viper.c:  Standalone Archive 2125s Driver */

char	request_sense[] = { 3, 0, 0, 0, 14, 0 };
char	unit_ready[] =  { 0, 0, 0, 0, 0, 0 };
char	write_data[] = { 0x0a, 1, 0, 0, 20, 0 };
char	read_data[] = { 8, 1, 0, 0, 20, 0 };
char	space_back_block[] = { 0x11, 0, 0, 0, 1, 0 };
char	rewind[] = { 1, 0, 0, 0, 0, 0};
char	write_eof[] = { 0x10, 0, 0, 0, 1, 0 };
char	led_on[] = { 0x1e, 0, 0, 0, 1, 0 };
char	led_off[] = { 0x1e, 0, 0, 0, 0, 0 };
char	release[] = { 0x17, 0, 0, 0, 0, 0 };
char	buf[10 * 1024];
char	data[14];
char	junk[2048];		/* trash for Mot roms */
#define	get4(x)	((x)[0] << 24 | (x)[1] << 16 | (x)[2] << 8 | (x)[3])
#define	set(x, y)	{x[2] = (y) >> 16 & 0xff; \
			 x[3] = (y) >> 8 & 0xff; \
			 x[4] = (y) & 0xff;}

main()
{
	int counter;
	int r, i;

	rscsi(1, request_sense, data, 14, 0);
	rscsi(1, unit_ready, 0, 0, 0);
	for (i = 0; i < 14; i++)
		printf("0x%x ", data[i] & 0xff);
	printf("\n");
	printf("Writing data....");
	for (i = 0; i < 32000; i++) {
		printf("%d        \n", i);
		rscsi(1, write_data, data, 10 * 1024, 0);
	}
	printf("\n");
	printf("writting file marks...");
	rscsi(1, write_eof, 0, 0, 0);
	printf("\n");
	printf("rewinding\n");
	rscsi(1, rewind, 0, 0, 0);
#ifdef nodef
	printf("reading what was written\n");
	counter = 0;
	while (rscsi(1, read_data, buf, 10 * 1024, 0) == 0)
		counter++;
	printf("read %d blocks\n", counter);
	rscsi(1, rewind, 0, 0, 0);
#endif
	printf("\ndone\n");
	for (;;);
}

rscsi(t, cdb, data, n, z)
	char *cdb, *data;
{
	register int r;

	r = scsi(t, cdb, data, n, z);
	if (r) {
		printf("0x%x: ", r);
		scsi(t, request_sense, data, 14, 0);
		printf("cmd 0x%x failed, sense key 0x%x\n", *cdb, data[2]);
		printf("fm %d eom %d\n", data[2] >> 7 & 01, data[2] >> 6 & 01);
		if (data[0] & 0x80)
			printf("Residual length %d\n", get4(&data[3]));
		return -1;
	}
	return 0;
}
