/* status driven routines to talk to the console for the mvme134 card. */

typedef	unsigned short ushort;

struct	mfp	{
	ushort	gpip;		/* general purpose io */
	ushort	aer;		/* active edge  */
	ushort	ddr;		/* data direction */
	ushort	iera;		/* interrupt enable */
	ushort	ierb;		/* interrupt enable b */
	ushort	ipra;		/* interrupt pending a */
	ushort	iprb;		/* interrupt pending b */
	ushort	isra;		/* interrupt in-service a */
	ushort	isrb;		/* interrupt in-service b */
	ushort	imra;		/* interrupt mask a */
	ushort	imrb;		/* interrupt mask b */
	ushort	vr;		/* vector */
	ushort	tacr;		/* timer A control */
	ushort	tbcr;		/* timer B control */
	ushort	tcdcr;		/* timers C and D control */
	ushort	tadr;		/* timer A data */
	ushort	tbdr;		/* timer B data */
	ushort	tcdr;		/* timer C data */
	ushort	tddr;		/* timer D control */
	ushort	scr;		/* synchronous character */
	ushort	ucr;		/* USART control */
	ushort	rsr;		/* receive status */
	ushort	tsr;		/* transmitter status */
	ushort	udr;		/* USART data */
};

/* bits in ucr */
#define	UCR_CLK	0200
#define	UCR_8BITS	0000
#define	UCR_7BITS	0040
#define UCR_6BITS	0100
#define	UCR_5BITS	0140
#define	UCR_SYNC	0000
#define UCR_1STOP	0010
#define	UCR_112STOP	0020
#define UCR_2STOP	0030
#define	UCR_PE		0004
#define UCR_EVEN	0002


/* bits for rcr */

#define	RSR_BF		0200
#define	RSR_OE		0100
#define RSR_PE		0040
#define	RSR_FE		0020
#define	RSR_BREAK	0010
#define	RSR_CIP		0004
#define	RSR_SS		0002
#define	RSR_RE		0001

/* bits for Transmitter status */

#define	TSR_BE		0200		/* buffer empty */
#define	TSR_UE		0100		/* under run */
#define	TSR_AT		0040		/* auto-turnaround */
#define	TSR_END		0020		/* end of transmission */
#define	TSR_BREAK	0010		/* Break */
#define	TSR_TE		0001		/* transmitter enable */

/* note that we use the REAL vmebus addresses here */

#define	MFP	((struct mfp *) 0xfff80000)


putchar(c)		/* print a character on the console status driven */
	char c;
{
	register s, timo;
	register char *cp;
	int x;

	while ((MFP->tsr & TSR_BE) == 0)
		;
	MFP->udr = c;
	if (c == '\n')
		putchar('\r');
}

getchar()		/* return the next character typed */
{
	register char c;

	while ((MFP->rsr & RSR_BF) == 0)
		;
	c = MFP->udr & 0177;
	if (c == '\r')
		c = '\n';
	putchar(c);
	return c;
}
