/*
 *	ps - process status
 *	examine and print certain things about processes
 */

#include <stdio.h>
#include <a.out.h>
#include <core.h>
#include <pwd.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/tty.h>
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/ipm.h>
#include <sys/sid.h>
#include <sys/seg.h>
#include <sys/user.h>
#include <sys/stat.h>

struct	proc mproc;
struct	user u;
int	chkpid;
int	retcode=1;
double	ttime = 0.0;		/* total cpu time */
int	lflg;		/* long */
int	uflg;		/* print user names */
int	mflg;		/* print adaptive message stuff */
int	nflg;		/* print unsorted */
int	xflg;		/* include shell and init process */
int	hflg;		/* print column headers */
int	aflg;		/* all users */
int	tflg;		/* filter out all except terminal 's' */
char	*tptr;
long	lseek();
char	*gettty();
char	*getptr();
char	*strncmp();
char	*getmytty();
char	*malloc();
int	mem;
int	swmem;
int	swap;
daddr_t	swplo;

int	ndev;
struct devl {
	char	dname[DIRSIZ];
	dev_t	dev;
} devl[256];

struct	proc	prc[NPROC];		/* place to sort procs */
int	nproc;
char	*coref;

main(argc, argv)
char **argv;
{
	int i;
	char *ap;
	int uid, puid;
	register struct proc *p;
	int prccmp();

	while (argc > 1) {
		ap = argv[1];
		argc--; argv++;
		while (*ap) switch (*ap++) {
		case 'u':
			uflg++;
			break;
		case 'm':
			mflg++;
			break;
		case 'h':
			hflg++;
			break;
		case 'a':
			aflg++;
			aflg++;
			break;
		case 'n':		/* names */
			nflg++;
			break;
		case 't':
			if(*ap)
				tptr = ap;
			aflg++;
			xflg++;
			tflg++;
			continue;
		case 'x':
			xflg++;
			break;
		case 'l':
			lflg++;
			break;
		default:
			chkpid = atoi(ap-1);
			continue;
			break;
		}
	}

	if(chdir("/dev") < 0) {
		fprintf(stderr, "Can't change to /dev\n");
		exit(1);
	}
	getnlist(argc > 2 ? argv[2] : "/unix");
	coref = "/dev/kmem";
	if ((mem = open(coref, 0)) < 0) {
		fprintf(stderr, "No mem\n");
		exit(1);
	}
	swmem = open(coref, 0);
	/*
	 * Find base of swap
	 */
	kseek(mem, lookup("_swplo"), 0);
	read(mem, (char *)&swplo, sizeof swplo);
	/*
	 * Locate proc table
	 */
	kseek(mem, lookup("_proc"), 0);
	getdev();
	if (tptr == NULL)
		tptr = getmytty();
	uid = getuid();
	if (hflg)
		pr_header();
	for (i = 0; i < NPROC; i++) {
		read(mem, (char *)&mproc, sizeof mproc);
		if (mproc.p_stat==0)
			continue;
		ttime += mproc.p_cpu;
		if (mproc.p_pid == 1 && xflg == 0)
			continue;
		if (mproc.p_ppid == 1 && xflg == 0)
			continue;
		puid = mproc.p_uid;
		if (uid != puid && aflg==0)
			continue;
		if (chkpid!=0 && chkpid!=mproc.p_pid)
			continue;
		if (mproc.p_pid == mproc.p_pgrp && xflg == 0)
			continue;
		prc[nproc++] = mproc;
	}
	if (nflg == 0)
		qsort((char *)prc, nproc, sizeof prc[0], prccmp);
	for (p = prc; p < &prc[nproc]; p++) {
		mproc = *p;
		if(prcom(puid)) {
			printf("\n");
			retcode=0;
		}
	}
	exit(retcode);
}

prccmp(a, b)
	char *a, *b;
{
	register struct proc *p1, *p2;

	p1 = (struct proc *)a;
	p2 = (struct proc *)b;
	if (uflg)
		return p2->p_cpu - p1->p_cpu;
	return p1->p_pid - p2->p_pid;
}


getdev()
{
	register FILE *df;
	struct stat sbuf;
	struct direct dbuf;

	if ((df = fopen("/dev", "r")) == NULL) {
		fprintf(stderr, "Can't open /dev\n");
		exit(1);
	}
	ndev = 0;
	while (fread((char *)&dbuf, sizeof(dbuf), 1, df) == 1) {
		if(dbuf.d_ino == 0)
			continue;
		if(stat(dbuf.d_name, &sbuf) < 0)
			continue;
		if ((sbuf.st_mode&S_IFMT) != S_IFCHR)
			continue;
		strncpy(devl[ndev].dname, dbuf.d_name, 14);
		devl[ndev].dev = sbuf.st_rdev;
		ndev++;
	}
	fclose(df);
	if ((swap = open("/dev/swap", 0)) < 0) {
		fprintf(stderr, "Can't open /dev/swap\n");
		exit(1);
	}
}

long
round(a, b)
	long		a, b;
{
	long		w = ((a+b-1)/b)*b;

	return(w);
}

struct map {
	long	b1, e1; long f1;
	long	b2, e2; long f2;
};
struct map datmap;
int	file;
prcom(puid)
{
	char abuf[512];
	long addr;
	register int *ip;
	register char *cp, *cp1;
	long tm;
	int c, nbad;
	register char *tp;
	long txtsiz, datsiz, stksiz;
	int septxt;
	int lw;
	char **ap;
	struct passwd *pw;
	int selectp = lookup("_selwait");
	int mesglistp = lookup("_mesglist");
	int sidp = lookup("_sid");
	int msgmapp = lookup("_msgmap");

	if (mproc.p_flag&SLOAD) {
		addr = ctob((long)mproc.p_addr);
		file = swmem;
	} else {
		addr = (long)(mproc.p_addr+swplo)<<9;
		file = swap;
	}
	lseek(file, addr, 0);
	if (read(file, (char *)&u, sizeof(u)) != sizeof(u))
		return(0);

	/* set up address maps for user pcs */
	txtsiz = ctob(u.u_tsize);
	datsiz = ctob(u.u_dsize);
	stksiz = ctob(u.u_ssize);
	datmap.b1 = round(txtsiz, TXTRNDSIZ);
	datmap.e1 = datmap.b1+datsiz;
	datmap.f1 = ctob(USIZE)+addr;
	datmap.b2 = stackbas(stksiz);
	datmap.e2 = stacktop(stksiz);
	datmap.f2 = ctob(USIZE)+(datmap.e1-datmap.b1)+addr;

	tp = gettty(u.u_ttyp, u.u_ttyd);
	if (tflg && strncmp(tptr, tp, 5))
		return(0);
	printf("%6u", mproc.p_pid);
	printf(" %-5.5s", tp);
	if (mproc.p_stat == SSLEEP && mproc.p_flag & SSWAP)
		printf(" W");
	else
		if (mproc.p_time > 20 && mproc.p_stat == SSLEEP)
			printf(" I");
		else
			printf(" %c", "?SWRIZT"[mproc.p_stat]);
	printf("%c ", mproc.p_nice > 20 ? 'N' : ' ');
	if (mproc.p_stat==SZOMB) {
		printf("  <defunct>");
		return(1);
	}
	tm = (u.u_utime + u.u_stime + 30)/60;
	tm = (tm > 60 * 999) ? 60 * 999 : tm;
	printf(" %3ld:", tm/60);
	tm %= 60;
	printf(tm<10?"0%ld":"%ld", tm);
	if (lflg) {
		printf("%4dK", ctob(mproc.p_size) + 1023 >> 10);
		printf("%6u", mproc.p_ppid);
		if (mproc.p_wchan) {
			if ((int)mproc.p_wchan == 0x04000000)
				printf(" %-8s", "pause");
			else if ((int)mproc.p_wchan == msgmapp)
				printf(" %-8s", "msgalloc");
			else if ((int)mproc.p_wchan >= sidp
				&& (int)mproc.p_wchan <= sidp + (sizeof (struct sid) * NSIDS))
				printf(" %-8s", "msgrecv");
			else if ((int)mproc.p_wchan == selectp)
				printf(" %-8s", "select");
			else if ((int)mproc.p_wchan == mesglistp)
				printf(" %-8s", "msgalloc");
			else
				printf("%9x", mproc.p_wchan);
		} else
			printf("         ");
	}
	if (uflg) {
		double percent;

		if ((pw = getpwuid(mproc.p_uid)) == 0)
			printf(" %8.8d", mproc.p_uid);
		else
			printf(" %-8.8s", pw->pw_name);
		percent = (100.0 * mproc.p_cpu) / ttime;
		printf("%5.1f", percent);
	}
	if (mflg) {
		struct mesg mesg;
		register l;
		register long *lp;
		register count = 0, maxcount = 0, tot = 0;

		for (lp = u.u_pte; lp < &u.u_pte[NPTE]; lp++)
			if (*lp) {
				tot++;
				count++;
			} else if (count > maxcount)
				maxcount = count;
		if (count > maxcount)
			maxcount = count;
		count = 0;
		for (l = (int)u.u_msglist; l; l = (int) mesg.next) {
			kseek(mem, l, 0);
			read(mem, (char *)&mesg, sizeof mesg);
			count++;
		}
		printf(" %6d %6d %3d", ctob(tot), ctob(maxcount), count);
	}
	if (mproc.p_pid == 0) {
		printf(" swapper");
		return(1);
	}
	addr += ctob((long)mproc.p_size) - 512;


	lw = 78;
	lw -= 23;
	if (lflg)
		lw -= 20;
	if (mflg)
		lw -= 18;
	if (uflg)
		lw -= 14;
	lseek(file, addr, 0);
	if (read(file, abuf, sizeof(abuf)) != sizeof(abuf))
		return(1);
	for (ip = (int *)&abuf[512]-3; ip > (int *)abuf; ) {
		if (*--ip == -1 || *ip==0) {
			cp = (char *)(ip+1);
			if (*cp==0)
				cp++;
			nbad = 0;
			for (cp1 = cp; cp1 < &abuf[512]; cp1++) {
				c = *cp1&0177;
				if (c==0)
					*cp1 = ' ';
				else if (c < ' ' || c > 0176) {
					if (++nbad >= 10) {
						*cp1++ = ' ';
						break;
					}
					*cp1 = '?';
				} else if (c=='=') {
					*cp1 = 0;
					while (cp1>cp && *--cp1!=' ')
						*cp1 = 0;
					break;
				}
			}
			while (*--cp1==' ')
				*cp1 = 0;
			printf(" %.*s", lw, cp);
			return(1);
		}
	}
	return(1);
}

char *
gettty(ttyp, ttyd)
	short	*ttyp;
	dev_t	ttyd;
{
	register i;
	register char *p;

	for (i=0; i<ndev; i++) {
		if (devl[i].dev == ttyd) {
			p = devl[i].dname;
			if (p[0]=='t' && p[1]=='t' && p[2]=='y')
				p += 3;
			return(p);
		}
	}
	return("?");
}

char *
getptr(adr)
char **adr;
{
	char *ptr;
	register char *p, *pa;
	register i;

	ptr = 0;
	pa = (char *)adr;
	p = (char *)&ptr;
	for (i=0; i<sizeof(ptr); i++)
		*p++ = getbyte(pa++);
	return(ptr);
}

getbyte(adr)
char *adr;
{
	register struct map *amap = &datmap;
	char b;
	long saddr;

	if(!within(adr, amap->b1, amap->e1)) {
		if(within(adr, amap->b2, amap->e2)) {
			saddr = (unsigned)adr + amap->f2 - amap->b2;
		} else
			return(0);
	} else
		saddr = (unsigned)adr + amap->f1 - amap->b1;
	if(lseek(file, saddr, 0)==-1
		   || read(file, &b, 1)<1) {
		return(0);
	}
	return((unsigned)b);
}


within(adr,lbd,ubd)
char *adr;
long lbd, ubd;
{
	return((unsigned)adr>=lbd && (unsigned)adr<ubd);
}

char *
getmytty()		/* return the device of the users process */
{
	register char *p;
	char *ttyname();
	char *rindex();

	if ((p = ttyname(0)) == NULL)
		return "?";
	if ((p = rindex(p, '/')) == NULL)
		return "?";
	p++;
	if (p[0]=='t' && p[1]=='t' && p[2]=='y')
		p += 3;
	return p;
}

struct	nlist 	*namelist;
int	nlistsize;

getnlist(name)		/* build in the symbol table */
	char *name;
{
	struct exec e;	/* header for the binary */
	int fd;
	char *strtab;
	struct nlist *loadnl();
	int nlcmp();
	char *loadstr();

	if ((fd = open(name, 0)) == -1) {
		perror(name);
		exit(1);
	}
	read(fd, (char *)&e, sizeof e);
	if (N_BADMAG(e)) {
		fprintf(stderr, "%s: bad magic\n", name);
		exit(1);
	}
	if (e.a_syms == 0) {
		fprintf(stderr, "%s: no sname list\n", name);
		exit(1);
	}
	nlistsize = e.a_syms / sizeof (struct nlist);
	namelist = loadnl(fd, &e);
	strtab = loadstr(fd, &e);
	fixstr(namelist, strtab, nlistsize);
	qsort((char *)namelist, nlistsize, sizeof (struct nlist), nlcmp);
}


struct nlist *
loadnl(fd, ep)		/* load the namelist from the file */
	register fd;
	register struct exec *ep;
{
	register struct nlist *np;

	lseek(fd, N_SYMOFF(*ep), 0);
	if ((np = (struct nlist *)malloc(ep->a_syms)) == NULL) {
		fprintf(stderr, "loadnl: out of memory (%d)\n", ep->a_syms);
		exit(1);
	}
	read(fd, (char *)np, ep->a_syms);
	return np;
}

char *
loadstr(fd, ep)		/* read in the string table from the a.out */
	register fd;
	register struct exec *ep;
{
	register char *s;
	int strsize;

	lseek(fd, N_STROFF(*ep), 0);
	read(fd, (char *)&strsize, sizeof strsize);
	if (strsize == 0) {
		fprintf(stderr, "no string table\n");	
		exit(1);
	}
	lseek(fd, N_STROFF(*ep), 0);
	if ((s = malloc(strsize)) == NULL) {
		fprintf(stderr, "loadstr: out of memory (%d)\n", ep->a_syms);
		exit(1);
	}
	read(fd, s, strsize - sizeof strsize);
	return s;
}

fixstr(np, s, n)		/* connect the symbols to the strings */
	register struct nlist *np;
	register char *s;		/* the strings */
	register n;			/* number of entries */
{
	register i;

	 while (n--) {
		if (i = np->n_un.n_strx)
			np->n_un.n_name = &s[i];
		np++;
	}
}

lookup(s)		/* find 's' in the namelist */
	register char *s;
{
	register n = nlistsize;
	register struct nlist *np;

	for (np = namelist; n--; np++) {
		if (*np->n_un.n_name == *s)
		if (strcmp(s, np->n_un.n_name) == 0)
			return np->n_value;
	}
	return 0;
}


nlcmp(a, b)
	char *a, *b;
{
	register struct nlist *p, *q;

	p = (struct nlist *)a;
	q = (struct nlist *)b;
	return p->n_value - q->n_value;
}


pr_header()
{
	printf("%6.6s ", "PID");
	printf("%-5.5s ", "TTY");
	printf("%-3.3s ", "ST");
	printf("%6.6s ", "TIME");
	if (lflg)
		printf("%s %5.5s %-8.8s ", "SIZE", "PPID", "WCHAN");
	if (uflg)
		printf("%-8.8s %s ", "USER", "CPU%");
	if (mflg)
		printf("%6s %6s %3s ", "FREEM", "CONTIG", "MSG");
	printf("COMMAND\n");
}
long
kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}
