static char *RCSid = "$Header: ascode.c,v 1.1 86/02/28 15:09:41 root Exp $";

/*
 * $Log:	ascode.c,v $
 * Revision 1.1  86/02/28  15:09:41  root
 * Initial revision
 * 
 */

/* Copyright (c) 1980 Regents of the University of California */
static	char sccsid[] = "@(#)ascode.c 4.7 11/5/80";
#include <stdio.h>
#include "as.h"
#include "assyms.h"

#define	JBSR	71
#define	JSR	160

#define	ASTAR	0

/*
 *	Loader reference types  (plust PCREL) to bytes and lg bytes
 */
/*		LEN1	LEN1+PC	LEN2	LEN2+PC	LEN4	LEN4+PC	LEN8	LEN8+PC*/
int	reflen[] = 	/* {LEN*+PCREL} ==> number of bytes */
{0,	0,	1,	1,	2,	2,	4,	4,	8,	8};	
int	lgreflen[] =	/* {LEN*+PCREL} ==> lg number of bytes */ 
{-1,	-1,	0,	0,	1,	1,	2,	2,	3,	3};

/*
 *	Sizes to Loader reference types and type flags
 */
/*0	1	2	3	4	5	6	7	8*/
int	len124[] = 	/* {1,2,4,8} ==> {LEN1, LEN2, LEN4, LEN8} */
{0,	LEN1,	LEN2,	0,	LEN4,	0,	0,	0,	LEN8};
char	mod124[] = 	/* {1,2,4,8} ==> {bits to construct operands */
{0,	0x00,	0x20,	0,	0x40,	0,	0,	0,	0};
int	type_124[] =	/* {1,2,4,8} ==> {TYPB, TYPW, TYPL, TYPQ} */
{0,	 TYPB,	TYPW,	 0,	 TYPL,	 0,	 0,	 0,	 TYPQ};

/*
 *	type flags to Loader reference and byte lengths
 */
/*TYPB	TYPW	TYPL	TYPQ	TYPF	TYPD*/
int	ty_NORELOC[] =	/* {TYPB..TYPD} ==> {1 if relocation not OK */
{0,	0,	0,	1,	1,	1};
int	ty_LEN[] =	/* {TYPB..TYPD} ==> {LEN1..LEN8} */
{LEN1,	LEN2,	LEN4,	LEN8,	LEN4,	LEN8};
int	ty_nbyte[] =	/* {TYPB..TYPD} ==> {1,2,4,8} */
{1,	2,	4,	8,	4,	8};
int	ty_nlg[] =	/* {TYPB..TYPD} ==> lg{1,2,4,8} */
{0,	1,	2,	3,	2,	3};

insout(op, ap, nact)
	register struct arg *ap;
	register short nact;
{
	short		jxxflg;
	register	struct	instab	*ip;		/* the instruction */

    tryagain:
	op &= 0xFF;
	jxxflg = nact;
	if (nact < 0)
		nact = -nact;
	if (passno == 1) {
	    ip = itab[op];
	    if (nact < ip->i_nargs) {
		yyerror("Too few arguments");
		return;
	    }
	    if (nact > ip->i_nargs) {
		yyerror("Too many arguments");
		return;
	    }
	    if (nact) {
	        register struct insfmt *fp = ip->I_ifmt;
		register short i;
		for (i = ip->I_nfmt;  i--;  fp++) {
			register struct arg *rap;
			register long *mp = &fp->if_m0;
			register short j;
			for (rap = ap, j = 0;  j++ < nact;  rap++) {
				if ((rap->a_atype & *mp++) == 0)
					goto nomatch;
			}
			break;
		    nomatch:
			continue;
		}
		if (i < 0) {
			if (op == JBSR) {	/* royal kludge */
				extern struct symtab *lastjxxx;
				extern int njxxx;
				lastjxxx->s_tag = JXINACTIVE;
				njxxx += 1;
				op = JSR;
				goto tryagain;
			}
			yyerror("invalid addressing mode");
			return;
		}
		if (op == JBSR  &&  ((ap->a_xp->e_xtype&XTYPE)==XABS)) {
			extern struct symtab *lastjxxx;
			extern int njxxx;
			lastjxxx->s_tag = JXINACTIVE;
			njxxx += 1;
			op = JSR;
			goto tryagain;
		}
	    }
	} /* both passes here */
	if (jxxflg < 0)
		ijxout(op, ap, nact);
	else putins(op, ap, nact);
}

extern	int d124;

putins(op, ap, n)
	register struct arg *ap;
{
	register struct insfmt *fp;
	register struct	instab	*ip;
	register short i;

#ifdef DEBUG
	fflush(stdout);
#endif
    tryagain:
	ip = itab[op];
	fp = ip->I_ifmt;
	for (i = ip->I_nfmt;  i--;  fp++) {
		register struct arg *rap;
		register long *mp = &fp->if_m0;
		register short j;
		for (rap = ap, j = 0;  j++ < n;  rap++) {
			if ((rap->a_atype & *mp++) == 0)
				goto nomatch;
		}
		mp = &fp->if_m0;
		for (rap = ap, j = 0;  j++ < n;  rap++, mp++) {
			register struct exp *xp;
			if (rap->a_atype & IMML)	/* imm of any size */
				rap->a_atype |= IMM;
			switch (rap->a_atype & 0xFFFF) {
			  case ABS:
				if (rap->a_xsize == 4) {
					rap->a_atype = ABSL;
					break;
				}
				if (rap->a_xsize == 2) {
					rap->a_atype = ABSS;
					break;
				}
				xp = rap->a_xp;
				if ((xp->e_xtype & XTYPE) == XABS  &&
				    !(xp->e_xtype & XFORW)) {
					if (xp->e_xvalue >= MINWORD  &&
					    xp->e_xvalue <= MAXWORD)
						rap->a_atype = ABSS;
					else
						rap->a_atype = ABSL;
				} else
					rap->a_atype = (d124==4) ? ABSL : ABSS;
				rap->a_xsize = (rap->a_atype == ABSS) ? 2 : 4;
				break;
			  case IMM:
				switch (*mp & (IMML & ~IMM)) {
				  case ~IMM&IMMSB:
				  case ~IMM&IMMB:	rap->a_xsize = 1; break;
				  case ~IMM&IMB3:
				  case ~IMM&IMB5:
				  case ~IMM&IMMSW:
				  case ~IMM&IMMW:	rap->a_xsize = 2; break;
				  case ~IMM&IMML:	rap->a_xsize = 4; break;
				  default:		rap->a_xsize = 0; break;
				}
				break;
			}
		}
		break;
	    nomatch:
		continue;
	}
	if (i < 0) {
		if (op == JBSR) {	/* royal kludge */
			op = JSR;
			goto tryagain;
		}
		yyerror("invalid mode");
		return;
	}
	if (op == JBSR  &&  ((ap->a_xp->e_xtype&XTYPE)==XABS)) {
		op = JSR;
		goto tryagain;
	}
	if (passno == 1)
		dotp->e_xvalue += 2;	/* at least one word for the opcode */
	(*fp->if_build)(fp->if_opcode, ap);
}

nop (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register short rop = op;
		outw (rop);
	}
}

r0 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register short rop = op | (ap->a_areg1 & 7);
		outw (rop);
	}
}

r0d (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register short rop = op | ((ap + 1)->a_areg1 & 7);
		outw (rop);
	}
}

r0_r9 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register struct arg *rp = ap;
		register short rop = op;
		rop |= (((rp + 1)->a_areg1 & 7) << 9) | (rp->a_areg1 & 7);
		outw (rop);
	}
}

r9_r0 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register struct arg *rp = ap;
		register short rop = op;
		rop |= ((rp->a_areg1 & 7) << 9) | ((rp + 1)->a_areg1 & 7);
		outw (rop);
	}
}

ea_r9 (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += easize (ap);
	else	/* passno == 2 */
		eaddr (op | (((ap + 1)->a_areg1 & 7) << 9), ap);
}

r9_ea (op, ap1)
  short op;
  register struct arg *ap1;
  {
	register struct arg *ap2 = ap1 + 1;

	if (passno != 2)
		dotp->e_xvalue += easize (ap2);
	else
		eaddr (op | ((ap1->a_areg1 & 7) << 9), ap2);
}

ea_ea6 (op, ap)
  register short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += easize (ap) + easize (ap + 1);
	else
		eaddr_eaddr (op, ap);
}

ea (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += easize (ap);
	else
		eaddr (op, ap);
}

ead (op, ap)
  short op;
  register struct arg *ap;
  {
	ap += 1;
	if (passno != 2)
		dotp->e_xvalue += easize (ap);
	else
		eaddr (op, ap);
}

q39_ea (op, ap1)
  short op;
  register struct arg *ap1;
  {
	register struct arg *ap2 = ap1 + 1;

	if (passno != 2)
		dotp->e_xvalue += easize (ap2);
	else
		eaddr (op | ((ap1->a_xp->e_xvalue & 7) << 9), ap2);
}

q39_r0 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register struct arg *rp = ap;
		register short rop = op;
		rop |= ((rp->a_xp->e_xvalue&7) << 9) | ((rp + 1)->a_areg1 & 7);
		outw (rop);
	}
}

qb0_r9 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register struct arg *rp = ap;
		register short rop = op;
		rop |= (((rp + 1)->a_areg1&7) << 9) | (rp->a_xp->e_xvalue&255);
		outw (rop);
	}
}

q40 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register short rop = op | (ap->a_xp->e_xvalue & 15);
		outw (rop);
	}
}

imm_ea (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2) {
		register short len = ap->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len + easize (ap + 1);
	} else {
		imm_eaddr (op, ap, ap + 1);
	}
}

ea_imm (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2) {
		register short len = (ap + 1)->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len + easize (ap);
	} else {
		imm_eaddr (op, ap + 1, ap);
	}
}

r0_imm (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2) {
		register short len = (ap + 1)->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len;
	} else {
		register short rop = op | ((ap++)->a_areg1 & 7);
		register short mode = type_124[ap->a_xsize];
		outw (rop);
		if (mode == TYPB)
			outb (0);
		outrel (ap->a_xp, mode);
	}
}

imm (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2) {
		register short len = ap->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len;
	} else {
		register short rop = op;
		register short mode = type_124[ap->a_xsize];
		outw (rop);
		if (mode == TYPB)
			outb (0);
		outrel (ap->a_xp, mode);
	}
}

r0_disp16 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		register struct arg *rp = ap;
		register short rop = op | (rp->a_areg1 & 7);
		outw (rop);
		outrel ((rp + 1)->a_xp, TYPW | RELOC_PCREL);
	}
}

disp8 (op, ap)
  unsigned short op;
  struct arg *ap;
  {
	if (passno == 2) {
		register short rop = op >> 8;
		outb (rop);
		ap->a_xp->e_xvalue -= 2;
		outrel (ap->a_xp, TYPB | RELOC_PCREL);
	}
}

disp16 (op, ap)
  short op;
  struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		register short rop = op;
		outw (rop);
		outrel (ap->a_xp, TYPW | RELOC_PCREL);
	}
}

movs_ea (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2 + easize (ap + 1);
	else
		w_eaddr (op, (ap->a_areg1 << 12) + 0x0800, ap + 1);
}

ea_movs (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2 + easize (ap);
	else
		w_eaddr (op, ((ap + 1)->a_areg1 << 12), ap);
}

static short contcode[4] = { 0x0800, 0x0801, 0x0000, 0x0001 };

r_c (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		register short rop = op;
		outw (rop);
		rop = (ap->a_areg1 << 12) | contcode[(ap + 1)->a_areg1 - 19];
		outw (rop);
	}
}

c_r (op, ap)
  short op;
  register struct arg *ap;
  {
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		register short rop = op;
		outw (rop);
		rop = ((ap + 1)->a_areg1 << 12) | contcode[ap->a_areg1 - 19];
		outw (rop);
	}
}

eaddr (op, ap)
  register short op;
  register struct arg *ap;
  {
	register short reg = ap->a_areg1 & 7;
	register short mode = 7;
	register unsigned short type = ap->a_atype;

	switch (type) {
	  case DREG:	mode = 0; break;
	  case AREG:	mode = 1; break;
	  case INDR:	mode = 2; break;
	  case INC:	mode = 3; break;
	  case DEC:	mode = 4; break;
	  case DISP:	mode = 5; break;
	  case INDEX:	mode = 6; break;
	  case ABSS:	reg = 0; break;
	  case ABSL:	reg = 1; break;
	  case PCDISP:	reg = 2; break;
	  case PCINDEX:	reg = 3; break;
	  case IMM:	reg = 4; break;
	  default:	yyerror("eaddr: strange mode 0x%x", type); return;
	}
	op |= (mode << 3) | reg;
	outw (op);
	if (mode < 5)
		return;

	switch (type) {

	  case DISP:	mode = TYPW;
			break;

	  case INDEX:	mode = TYPB;
			goto index;

	  case PCDISP:	mode = TYPW;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
			break;

	  case PCINDEX:	mode = TYPB;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
		index:	op = (ap->a_areg2 << 4);
			if (ap->a_xsize != 2)
				op |= (1 << 3);
			outb (op);
			break;

	  case ABSS:	mode = TYPW;
			break;

	  case ABSL:	mode = TYPL;
			break;

	  case IMM:	if ((mode = type_124[ap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (ap->a_xp, mode);
}

easize (ap)
  register struct arg *ap;
  {
	register short size;

	switch (ap->a_atype & 0xFFFF) {
	  case DISP:	return 2;
	  case INDEX:	return 2;
	  case ABSS:	return 2;
	  case ABSL:	return 4;
	  case PCDISP:	return 2;
	  case PCINDEX:	return 2;
	  case IMM:	if ((size = ap->a_xsize) == 1) size = 2; return size;
	}
	return 0;
}

imm_eaddr (op, ap_imm, ap)
  register short op;
  register struct arg *ap_imm, *ap;
  {
	register short reg = ap->a_areg1 & 7;
	register short mode = 7, rmode;
	register unsigned short type = ap->a_atype;

	switch (type) {
	  case DREG:	mode = 0; break;
	  case AREG:	mode = 1; break;
	  case INDR:	mode = 2; break;
	  case INC:	mode = 3; break;
	  case DEC:	mode = 4; break;
	  case DISP:	mode = 5; break;
	  case INDEX:	mode = 6; break;
	  case ABSS:	reg = 0; break;
	  case ABSL:	reg = 1; break;
	  case PCDISP:	reg = 2; break;
	  case PCINDEX:	reg = 3; break;
	  case IMM:	reg = 4; break;
	  default:	yyerror("imm_eaddr: strange mode 0x%x", type); return;
	}
	op |= (mode << 3) | reg;
	outw (op);

	rmode = type_124[ap_imm->a_xsize];
	if (rmode == TYPB)
		outb (0);
	outrel (ap_imm->a_xp, rmode);

	if (mode < 5)
		return;

	switch (type) {

	  case DISP:	mode = TYPW;
			break;

	  case INDEX:	mode = TYPB;
			goto index;

	  case PCDISP:	mode = TYPW;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
			break;

	  case PCINDEX:	mode = TYPB;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
		index:	op = (ap->a_areg2 << 4);
			if (ap->a_xsize != 2)
				op |= (1 << 3);
			outb (op);
			break;

	  case ABSS:	mode = TYPW;
			break;

	  case ABSL:	mode = TYPL;
			break;

	  case IMM:	if ((mode = type_124[ap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (ap->a_xp, mode);
}

w_eaddr (op, w, ap)
  register short op, w;
  register struct arg *ap;
  {
	register short reg = ap->a_areg1 & 7;
	register short mode = 7;
	register unsigned short type = ap->a_atype;

	switch (type) {
	  case DREG:	mode = 0; break;
	  case AREG:	mode = 1; break;
	  case INDR:	mode = 2; break;
	  case INC:	mode = 3; break;
	  case DEC:	mode = 4; break;
	  case DISP:	mode = 5; break;
	  case INDEX:	mode = 6; break;
	  case ABSS:	reg = 0; break;
	  case ABSL:	reg = 1; break;
	  case PCDISP:	reg = 2; break;
	  case PCINDEX:	reg = 3; break;
	  case IMM:	reg = 4; break;
	  default:	yyerror("w_eaddr: strange mode 0x%x", type); return;
	}
	op |= (mode << 3) | reg;
	outw (op);

	outw (w);

	if (mode < 5)
		return;

	switch (type) {

	  case DISP:	mode = TYPW;
			break;

	  case INDEX:	mode = TYPB;
			goto index;

	  case PCDISP:	mode = TYPW;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
			break;

	  case PCINDEX:	mode = TYPB;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
		index:	op = (ap->a_areg2 << 4);
			if (ap->a_xsize != 2)
				op |= (1 << 3);
			outb (op);
			break;

	  case ABSS:	mode = TYPW;
			break;

	  case ABSL:	mode = TYPL;
			break;

	  case IMM:	if ((mode = type_124[ap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (ap->a_xp, mode);
}

eaddr_eaddr (op, ap)
  register short op;
  register struct arg *ap;
  {
	register short reg = ap->a_areg1 & 7;
	register short mode = 7;
	register unsigned short type = ap->a_atype;
	register struct arg *dap;

	switch (type) {
	  case DREG:	mode = 0; break;
	  case AREG:	mode = 1; break;
	  case INDR:	mode = 2; break;
	  case INC:	mode = 3; break;
	  case DEC:	mode = 4; break;
	  case DISP:	mode = 5; break;
	  case INDEX:	mode = 6; break;
	  case ABSS:	reg = 0; break;
	  case ABSL:	reg = 1; break;
	  case PCDISP:	reg = 2; break;
	  case PCINDEX:	reg = 3; break;
	  case IMM:	reg = 4; break;
	  default:	yyerror("eaddr_eaddr: 1st op strange mode 0x%x", type); return;
	}
	op |= (mode << 3) | reg;

	dap = ap + 1;
	reg = dap->a_areg1 & 7;
	mode = 7;
	type = dap->a_atype;

	switch (type) {
	  case DREG:	mode = 0; break;
	  case AREG:	mode = 1; break;
	  case INDR:	mode = 2; break;
	  case INC:	mode = 3; break;
	  case DEC:	mode = 4; break;
	  case DISP:	mode = 5; break;
	  case INDEX:	mode = 6; break;
	  case ABSS:	reg = 0; break;
	  case ABSL:	reg = 1; break;
	  case PCDISP:	reg = 2; break;
	  case PCINDEX:	reg = 3; break;
	  case IMM:	reg = 4; break;
	  default:	yyerror("eaddr_eaddr: 2nd strange mode 0x%x", type); return;
	}
	op |= (mode << 6) | (reg << 9);

	outw (op);

	switch (ap->a_atype & 0xFFFF) {

	  case DREG:
	  case AREG:
	  case INDR:
	  case INC:
	  case DEC:	goto destext;

	  case DISP:	mode = TYPW;
			break;

	  case INDEX:	mode = TYPB;
			goto index;

	  case PCDISP:	mode = TYPW;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
			break;

	  case PCINDEX:	mode = TYPB;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
		index:	op = (ap->a_areg2 << 4);
			if (ap->a_xsize != 2)
				op |= (1 << 3);
			outb (op);
			break;

	  case ABSS:	mode = TYPW;
			break;

	  case ABSL:	mode = TYPL;
			break;

	  case IMM:	if ((mode = type_124[ap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (ap->a_xp, mode);

  destext:
	switch (dap->a_atype & 0xFFFF) {

	  case DREG:
	  case AREG:
	  case INDR:
	  case INC:
	  case DEC:	return;

	  case DISP:	mode = TYPW;
			break;

	  case INDEX:	mode = TYPB;
			goto dindex;

	  case PCDISP:	mode = TYPW;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
			break;

	  case PCINDEX:	mode = TYPB;
			if ((ap->a_xp->e_xtype & ~XFORW) != XABS)
				mode |= RELOC_PCREL;
		dindex:	op = (dap->a_areg2 << 4);
			if (dap->a_xsize != 2)
				op |= (1 << 3);
			outb (op);
			break;

	  case ABSS:	mode = TYPW;
			break;

	  case ABSL:	mode = TYPL;
			break;

	  case IMM:	if ((mode = type_124[dap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (dap->a_xp, mode);
}
