/* access.c:  Operations on the two file come here. */
#include <stdio.h>
#include <assert.h>
#include <a.out.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>

#define	USEG	(0x04000000)
#define	NMAPS	8

struct	map	{
	int	t;		/* type of map */
	int	b;		/* beginning of space */
	int	e;		/* end of space */
	int	f;		/* offset in the file to 'b' */
	int 	fd;
};

static	struct	map	maptab[NMAPS];	/* address maps */
static	int	next_map;		/* next open map slot */
static	struct	exec	h;		/* header file of obj */
static	union {	
	struct user u;
	char space[8 *1024];
} u_un;
#define	useg	u_un.u

static	int	nfd;		/* fd of namelist file */
static	int	cfd;		/* fd of core file */

set_access(obj, cor)		/* setup access to files */
	char *obj, *cor;
{
	register int b, e, f;

	if ((nfd = open(obj, 0)) == -1) {
		perror(obj);
		exit(1);
	}
	if ((cfd = open(cor, 0)) == -1) {
		perror(cor);
	}
	if (read(nfd, (char *)&h, sizeof h) != sizeof h) {
		fprintf(stderr, "Can't read header from file %s\n", obj);
		exit(1);
	}
	if (h.a_magic == OMAGIC) {
		b = USRBASE;
		e = USRBASE + h.a_text + h.a_data;
		f = sizeof h;
		set_map(1, b, e, f, nfd);
		setsyms(nfd);
	} else if (h.a_magic == NMAGIC) {
		b = USRBASE;
		e = b + h.a_text;
		f = sizeof h;
		set_map(1, b, e, f, nfd);
		b = e;
		e += h.a_data;
		f += h.a_text;
		set_map(1, b, e, f, nfd);
		setsyms(nfd);
	} else		/* just a file */
		set_map(1, 0, 0x7fffffff, 0, nfd);

	/* Read core header */

	if (read(cfd, (char *)&u_un, sizeof u_un) != sizeof u_un) {
		fprintf(stderr, "Can't read useg from header\n");
		return;
	}
	if (useg.u_exdata.ux_stamp != OMAGIC)
	if (useg.u_exdata.ux_stamp != NMAGIC) {
		fprintf(stderr, "Bad core magic number\n");
		return;
	}
	b = USRBASE + ctob(useg.u_tsize);
	e = b + ctob(useg.u_dsize);
	f = sizeof u_un;
	set_map(0, b, e, f, cfd);
	b = 0x08100000 - ctob(useg.u_ssize);
	e = 0x08100000;
	f = sizeof u_un + ctob(useg.u_dsize);
	set_map(0, b, e, f, cfd);
	b = USEG;
	e = USEG + ctob(USIZE);
	f = 0;
	set_map(0, b, e, f, cfd);
}

fetch(obj, addr, word)			/* fetch word from memory */
	int *word;
{
	int w;
	register struct map *mp;
	struct map *get_map();

	if ((mp = get_map(obj, addr)) == (struct map *) -1) {
		printf("address out of range\n");
		return 0;
	}
	addr += mp->f - mp->b;
	lseek(mp->fd, addr, 0);
	read(mp->fd, (char *)&w, sizeof w);
	*word = w;
	return 1;
}

pr_maps()			/* print all the maps */
{
	register struct map *mp;

	for (mp = maptab; mp < &maptab[next_map]; mp++) {
		printf("%c ", mp->t ? '?' : '/');
		printf("b = 0x%x, e = 0x%x, f = 0x%x\n", mp->b, mp->e, mp->f);
	}
}

static
set_map(obj, b, e, f, fd)
{
	register struct map *mp;

	assert(next_map <= NMAPS);
	mp = &maptab[next_map++];
	mp->t = obj;
	mp->b = b;
	mp->e = e;
	mp->f = f;
	mp->fd = fd;
}


static
struct map *
get_map(obj, a)			/* find map for address */
{
	register struct map *mp;

	for (mp = maptab; mp < &maptab[next_map]; mp++)
		if (mp->b <= a && a < mp->e && mp->t == obj)
			return mp;
	return (struct map *) -1;
}


get_reg(word, n)			/* return register 'n' */
	int *word;
{
	int addr, w;
	struct map *mp, *get_map();

	if ((mp = get_map(0, (long) useg.u_ar0)) == NULL) {
		printf("no core file\n");
		return 0;
	}
	addr = (long) useg.u_ar0 - mp->b + mp->f;
	addr += n << 2;
	lseek(mp->fd, addr, 0);
	read(mp->fd, (char *)&w, sizeof w);
	*word = w;
	return 1;
}
