/* (-lgl
 *	Coherent 386 release 4.2
 *	Copyright (c) 1982, 1993 by Mark Williams Company.
 *	All rights reserved. May not be copied without permission.
 *	For copying permission and licensing info, write licensing@mwc.com
 -lgl) */

#ifndef	__KERNEL_DEFER_H__
#define	__KERNEL_DEFER_H__

#include <common/ccompat.h>
#include <kernel/_cpuid.h>
#include <kernel/_defer.h>

/*
 * An interesting facility is used in the COHERENT kernel; called defer (), it
 * requests that a function (with a single argument) be called before return
 * to user level.   At present, it is used to solve problems of poor design
 * such as not having interrupts prioritized, and (b) as a global approach
 * for synchronization issues by moving parts of interrupt code out into base
 * level, where no thought need be given to synchronization.
 *
 * The version presented here has two aims:  as a general mechanism for
 * deferring activity for "return to user level" time to reduce interrupt
 * latency, and as a mechanism for binding activities to specific processors.
 * A benefit of using this approach is simplifying the complex set of "before
 * we return to user level" features.
 *
 * Note that this version does not permit callback functions to take any
 * parameters, thus avoiding type problems (see bufcall () for some of these
 * that AT&T have foisted on us) and also discourages using it in fashion (b)
 * above.
 */


__EXTERN_C_BEGIN__

int		defer_int_cpu	__PROTO ((__deffuncp_t _funcp,
					  processorid_t _cpuid));
int		defer_int_any	__PROTO ((__deffuncp_t _funcp));
int		defer_int_here	__PROTO ((__deffuncp_t _funcp));

int		defer_proc_cpu	__PROTO ((__deffuncp_t _funcp,
					  processorid_t _cpuid));
int		defer_proc_any	__PROTO ((__deffuncp_t _funcp));
int		defer_proc_here	__PROTO ((__deffuncp_t _funcp));

__EXTERN_C_END__


#endif	/* ! defined (__KERNEL_DEFER_H__) */
