/*
 * devload.c - call the load routine for a device driver
 *
 * Useful mainly during installation.  Sometime after booting, patch
 * the "con" address for a driver into drvl+..., then use this
 * command with the device major number to start up the driver.
 *
 * Usage - devload major_number
 */
#include <stdio.h>
#include <sys/param.h>

main(argc, argv)
int argc;
char ** argv;
{
	int res;
	unsigned int a2;

	if (argc == 2) {
		if (sscanf(argv[1], "%d", &a2) == 1) {
			if (a2 < NDRV) {
				res = cohcall(COH_DEVLOAD, a2);
				if (res == -1) {
					perror("devload");
					exit(1);
				} else
					exit(0);
			} else {
				fprintf(stderr,
"Major number is %d - must be between 0 and %d\n", a2, NDRV-1);
				exit(1);
			}
		} else {
			fprintf(stderr, "Usage:  %s major_number\n", argv[0]);
			exit(1);
		}
	} else {
		fprintf(stderr, "Usage:  %s major_number\n", argv[0]);
		exit(1);
	}
}
