/*
 * libc/stdio/tmpnam.c
 * ANSI-compliant C standard i/o library.
 * tmpnam()
 * ANSI 4.9.4.4.
 * Generate a temporary file name a la SV.
 * The name (generated by mktemp()) is of the form "/tmp/t<pid>x",
 * where <pid> is the 5-digit pid and x is an ASCII character.
 */

#include <stdio.h>
#include <string.h>

extern	char *mktemp();

#ifdef	GEMDOS
#define	FSPATHSEP	"\\"
#ifndef	P_tmpdir
#define	P_tmpdir	"\\tmp"
#endif
#endif
#ifdef	DOS
#define	FSPATHSEP	"\\"
#ifndef	P_tmpdir
#define	P_tmpdir	"\\tmp"
#endif
#endif
#ifndef	FSPATHSEP
#define	FSPATHSEP	"/"
#ifndef	P_tmpdir
#define	P_tmpdir	"/tmp"
#endif
#endif
#ifndef	L_tmpnam
#define	L_tmpnam	64
#endif
#define	TEMPLATE	"tXXXXXX"

char *
tmpnam(s) register char *s;
{
	static char namebuf[L_tmpnam];
	char *name;

	if (s == NULL)
		s = namebuf;
	for (;;) {
		strcpy(s, P_tmpdir);
		strcat(s, FSPATHSEP);
		strcat(s, TEMPLATE);
		name = mktemp(s);
		if (access(name, 0) == -1)
			break;
	}
	return name;
}

/* end of libc/stdio/tmpnam.c */
