     PAX         COHERENT (USENIX Association)         PAX
     NAME
          pax - portable archive exchange
     SYNOPSIS
          pax [-cimopuvy] [-f archive] [-s replstr] [-t device]
              [pattern...]
          pax -r [-cimnopuvy] [-f archive] [-s replstr] [-t device]
                 [pattern...]
          pax -w [-adimuvy] [-b blocking] [-f archive] [-s replstr]
                 [-t device] [-x format] [pathname...]
          pax -rw [-ilmopuvy] [-s replstr] [pathname...] directory
     DESCRIPTION
          Pax reads and writes archive files which conform to the
          Archive/Interchange File Format specified in IEEE Std.
          1003.1-1988.  Pax can also read, but not write, a number of
          other file formats in addition to those specified in the
          Archive/Interchange File Format description.  Support for
          these traditional file formats, such as V7 tar and System V
          binary cpio format archives, is provided for backward
          compatibility and to maximize portability.
          Pax will also support traditional cpio and System V tar
          interfaces if invoked with the name "cpio" or "ustar"
          respectively.  See the cpio or ustar manual pages for
          more details.
          Combinations of the -r and -w command line arguments specify
          whether pax will read, write or list the contents of the
          specified archive, or move the specified files to another
          directory.
          The command line arguments are:
          -w   writes the files and directories specified by pathname
               operands to the standard output together with the
               pathname and status information prescribed by the
               archive format used.  A directory pathname operand
               refers to the files and (recursively) subdirectories of
               that directory.  If no pathname operands are given,
               then the standard input is read to get a list of
               pathnames to copy, one pathname per line.  In this
               case, only those pathnames appearing on the standard
               input are copied.
          -r   Pax reads an archive file from the standard input.
               Only files with names that match any of the pattern
               operands are selected for extraction.  The selected
               files are conditionally created and copied relative to
     Page 1                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
               the current directory tree, subject to the options
               described below.  By default, the owner and group of
               selected files will be that of the invoking process,
               and the permissions and modification times will be the
               sames as those in the archive.
               The supported archive formats are automatically
               detected on input.  The default output format is ustar,
               but may be overridden by the -x format option described
               below.
          -rw  Pax reads the files and directories named in the
               pathname operands and copies them to the destination
               directory.  A directory pathname operand refers to the
               files and (recursively) subdirectories of that
               directory.  If no pathname operands are given, the
               standard input is read to get a list of pathnames to
               copy, one pathname per line.  In this case, only those
               pathnames appearing on the standard input are copied.
               The directory named by the directory operand must exist
               and have the proper permissions before the copy can
               occur.
          If neither the -r or -w options are given, then pax will
          list the contents of the specified archive.  In this mode,
          pax lists normal files one per line, hard link pathnames as
                    pathname == linkname
          and symbolic link pathnames (if supported by the
          implementation) as
                    pathname -> linkname
          where pathname is the name of the file being extracted, and
          linkname is the name of a file which appeared earlier in the
          archive.
          If the -v option is specified, then pax list normal
          pathnames in the same format used by the ls utility with the
          -l option.  Hard links are shown as
                    <ls -l listing> == linkname
          and symbolic links (if supported) are shown as
                    <ls -l listing> -> linkname
          Pax is capable of reading and writing archives which span
          multiple physical volumes.  Upon detecting an end of medium
          on an archive which is not yet completed, pax will prompt
     Page 2                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
          the user for the next volume of the archive and will allow
          the user to specify the location of the next volume.
        Options
          The following options are available:
          -a        The files specified by pathname are appended to
                    the specified archive.
          -b blocking
                    Block the output at blocking bytes per write to
                    the archive file.  A k suffix multiplies blocking
                    by 1024, a b suffix multiplies blocking by 512 and
                    a m suffix multiplies blocking by 1048576 (1
                    megabyte).  If not specified, blocking is
                    automatically determined on input and is ignored
                    for -rw.
          -c        Complement the match sense of the the pattern
                    operands.
          -d        Intermediate directories not explicitly listed in
                    the archive are not created.  This option is
                    ignored unless the -r option is specified.
          -f archive
                    The archive option specifies the pathname of the
                    input or output archive, overriding the default of
                    standard input for -r or standard output for -w.
          -i        Interactively rename files.  Substitutions
                    specified by -s options (described below) are
                    performed before requesting the new file name from
                    the user.  A file is skipped if an empty line is
                    entered and pax exits with an exit status of 0 if
                    EOF is encountered.
          -l        Files are linked rather than copied when possible.
          -m        File modification times are not retained.
          -n        When -r is specified, but -w is not, the pattern
                    arguments are treated as ordinary file names.
                    Only the first occurrence of each of these files
                    in the input archive is read.  The pax utility
                    exits with a zero exit status after all files in
                    the list have been read.  If one or more files in
                    the list is not found, pax writes a diagnostic to
                    standard error for each of the files and exits
                    with a non-zero exit status.  the file names are
                    compared before any of the -i, -s, or -y options
                    are applied.
     Page 3                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
          -o        Restore file ownership as specified in the
                    archive.  The invoking process must have
                    appropriate privileges to accomplish this.
          -p        Preserve the access time of the input files after
                    they have been copied.
          -s replstr
                    File names are modified according to the
                    substitution expression using the syntax of ed
                    as shown:
                              -s /old/new/[gp]
                    Any non null character may be used as a delimiter
                    (a / is used here as an example).  Multiple -s
                    expressions may be specified; the expressions are
                    applied in the order specified terminating with
                    the first successful substitution.  The optional
                    trailing p causes successful mappings to be listed
                    on standard error.  The optional trailing g causes
                    the old expression to be replaced each time it
                    occurs in the source string.  Files that
                    substitute to an empty string are ignored both on
                    input and output.
          -t device The device option argument is an implementation-
                    defined identifier that names the input or output
                    archive device, overriding the default of standard
                    input for -r and standard output for -w.
          -u        Copy each file only if it is newer than a pre-
                    existing file with the same name.  This implies
                    -a.
          -v        List file names as they are encountered.  Produces
                    a verbose table of contents listing on the
                    standard output when both -r and -w are omitted,
                    otherwise the file names are printed to standard
                    error as they are encountered in the archive.
          -x format Specifies the output archive format.  The input
                    format, which must be one of the following, is
                    automatically determined when the -r option is
                    used.  The supported formats are:
          cpio      The extended CPIO interchange format specified in
                    Extended CPIO Format in IEEE Std. 1003.1-1988.
          ustar     The extended TAR interchange format specified in
                    Extended TAR Format in IEEE Std. 1003.1-1988. This
                    is the default archive format.
     Page 4                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
          -y        Interactively prompt for the disposition of each
                    file.  Substitutions specified by -s options
                    (described above) are performed before prompting
                    the user for disposition.  EOF or an input line
                    starting with the character q caused pax to exit.
                    Otherwise, an input line starting with anything
                    other than y causes the file to be ignored.  This
                    option cannot be used in conjunction with the -i
                    option.
          Only the last of multiple -f or -t options take effect.
          When writing to an archive, the standard input is used as a
          list of pathnames if no pathname operands are specified.
          The format is one pathname per line.  Otherwise, the
          standard input is the archive file, which is formatted
          according to one of the specifications in
          Archive/Interchange File format in IEEE Std. 1003.1-1988, or
          some other implementation-defined format.
          The user ID and group ID of the process, together with the
          appropriate privileges, affect the ability of pax to restore
          ownership and permissions attributes of the archived files.
          (See format-reading utility in Archive/Interchange File
          Format in IEEE Std. 1003.1-1988.)
          The options -a, -c, -d, -i, -l, -p, -t, -u, and -y are
          provided for functional compatibility with the historical
          cpio and tar utilities.  The option defaults were chosen
          based on the most common usage of these options, therefore,
          some of the options have meanings different than those of
          the historical commands.
        Operands
          The following operands are available:
          directory The destination directory pathname for copies when
                    both the -r and -w options are specified.  The
                    directory must exist and be writable before the
                    copy or and error results.
          pathname  A file whose contents are used instead of the
                    files named on the standard input.  When a
                    directory is named, all of its files and
                    (recursively) subdirectories are copied as well.
          pattern   A pattern is given in the standard shell pattern
                    matching notation.  The default if no pattern is
                    specified is *, which selects all files.
     EXAMPLES
          The following command
     Page 5                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
                    pax -w -f /dev/rmt0 .
          copies the contents of the current directory to tape drive
          0.
          The commands
                    mkdir newdir
                    cd olddir
                    pax -rw . newdir
          copies the contents of olddir to newdir .
          The command
                    pax -r -s ',//*usr//*,,' -f pax.out
          reads the archive pax.out with all files rooted in "/usr" in
          the archive extracted relative to the current directory.
     FILES
          /dev/tty  used to prompt the user for information when the
                    -i or -y options are specified.
     SEE ALSO
          cpio, find, ustar
     DIAGNOSTICS
          Pax will terminate immediately, without processing any
          additional files on the command line or in the archive.
     EXIT CODES
          Pax will exit with one of the following values:
          0    All files in the archive were processed successfully.
          >0   Pax aborted due to errors encountered during operation.
     BUGS
          Special permissions may be required to copy or extract
          special files.
          Device, user ID, and group ID numbers larger than 65535
          cause additional header records to be output.  These records
          are ignored by some historical version of cpio and
          tar.
          The archive formats described in Archive/Interchange File
          Format have certain restrictions that have been carried over
          from historical usage.  For example, there are restrictions
          on the length of pathnames stored in the archive.
     Page 6                                          (printed 5/24/90)
     PAX         COHERENT (USENIX Association)         PAX
          When getting an "ls -l" style listing on tar format
          archives, link counts are listed as zero since the ustar
          archive format does not keep link count information.

     COPYRIGHT
          Copyright (c) 1989 Mark H. Colburn.
	  COHERENT pax/ustar/cpio are based on original code for pax
	  which is sponsored by The USENIX Association.

     Page 7                                          (printed 5/24/90)
