/*
 * mkserial.c
 * 4/24/90
 * Calculate encrypted serial numbers and print to stdout.
 */

#include	<stdio.h>
#include 	"serialno.h"

void	usage();

main(argc, argv) int argc; char *argv[];
{
	char	c;
	register int i, finish, start, total;

	if (argc != 4)
		usage();
	if ((c = atoi(argv[1])) < 1 || c > VERSIONS) {
		fprintf(stderr, "mkserial: bad version \"%s\"\n", argv[1]);	
		exit(1);
	}
	else if ((start = atoi(argv[2])) < 1) {
		fprintf(stderr, "mkserial: bad start \"%s\"\n", argv[2]);	
		exit(1);
	}
	else if ((total = atoi(argv[3])) < 1) {
		fprintf(stderr, "mkserial: bad count \"%s\"\n", argv[3]);	
		exit(1);
	}

	finish = start + total;
	--c;
	for (i = start; i < finish; i ++)
		printf("%1d%03d%05d\n", c + 1,
			magic1[c] ^ (i % magic2[c]), i ^ magic3[c]);
	exit(0);
}

/*
 * Print usage message and die.
 */
void 
usage()
{
	fprintf(stderr, "Usage: mkserial version start count\n");
	exit(1);
}
