/*
 *	/usr/include/termios.h
 *
 *	TERMIOS line discipline support for System V.3
 *	supports POSIX.1 and SVR4 termios, not BSD4.3
 *
 *	Udo Munk (udo@umunk.GUN.de)
 */

#ifndef __TERMIOS_H__
#define __TERMIOS_H__

#include <termio.h>

#define termios termio

extern struct termio __tty__;

/* Getting and Setting terminal attributes */

#define tcgetattr(filedes,termptr)		ioctl(filedes,TCGETA,termptr)
#define tcsetattr(filedes,opt,termptr)		ioctl(filedes,opt,termptr)

/* Possible values for opt to set the terminal attributes */

#define TCSANOW   TCSETA	/* change attributes immediately */
#define TCSADRAIN TCSETAW	/* wait for drain, then change attributes */
#define TCSAFLUSH TCSETAF	/* wait for drain, flush input, then change attributes */

/* Line control functions */

#define tcdrain(fieldes)			ioctl(filedes,TCGETA,&__tty__),\
						ioctl(filedes,TCSETAW,&__tty__)
#define tcflow(filedes,action)			ioctl(filedes,TCXONC,action)
#define tcflush(filedes,queue)			ioctl(filedes,TCFLSH,queue)
#define tcsendbreak(filedes,duration)		ioctl(filedes,TCSBRK,0)

/* Possible values for action to set flow control */

#define TCOOFF		0	/* output is suspended */
#define TCOON		1	/* output that priviously was suspende is restarted */
#define TCIOFF		2	/* system transmits a STOP character, not implemented yet */
#define TCION		2	/* system transmits a START character, not implemented yet */

/* Possible values for queue to flush */

#define TCIFLUSH	0	/* the input queue is flushed */
#define TCOFLUSH	1	/* the output queue is flushed */
#define TCIOFLUSH	2	/* both the input and output queues are flushed */

/* Baud rate functions */

#define cfgetispeed(termptr)			__get_tty_speed__(termptr)
#define cfgetospeed(termptr)			__get_tty_speed__(termptr)
#define cfsetispeed(termptr,speed)		__set_tty_speed__(termptr,speed)
#define cfsetospeed(termptr,speed)		__set_tty_speed__(termptr,speed)

/* compatibility defines for c_iflag */

#define IMAXBEL		0	/* ring bell on input queue full, not implemented yet */

/* compatibility defines for c_lflag */

#define ECHOCTL		0	/* echo control chars as ^(Char), not implemented yet */
#define ECHOKE		0	/* visual erase for kill, not implemented yet */
#define ECHOPRT		0	/* visual erase mode for hardcopy, not implemented yet */
#define FLUSHO		0	/* output being flushed, not implemented yet */
#define IEXTEN		0	/* enable extended input char processing, not implemented yet */
#define PENDIN		0	/* retype pending input, not implemented yet */
#define TOSTOP		0	/* send SIGTTOU for background output, not implemented yet */

/* POSIX.1 compatibility for suspend signal */

#define SUSP		CSWTCH
#define VSUSP		VSWTCH

#endif __TERMIOS_H__
