/*
   Copyright (c) 1994 by Harry Pulley.

   May be freely distributed and modified provided that this copyright notice
   is not removed.  I am not responsible for any damages caused in any way,
   shape or form.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <poll.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/sbioctl.h>

unsigned char tconst;
unsigned short samplespersec;
FILE *fp;
struct pollfd sbpoll[2];
struct sb_ioctl sbis;
unsigned char sb_status;

int sb_fd;

char *aligned0,*aligned1;

void main ( argc, argv )
int argc;
char **argv;
{
    int num=0,done=0;

    if(argc<3)
    {
        printf("%s <filename> <samplerate>.\n",argv[0]);

        exit(1);
    }

    sb_fd=open("/dev/sb",O_RDWR);

    if (sb_fd<0)
    {
	printf("Unable to open SB device.\n");

	exit(1);
    }

    sbpoll[0].fd=sb_fd;
    sbpoll[0].events=POLLIN;

    sbpoll[1].fd=fileno(stdin);
    sbpoll[1].events=POLLIN;

    if((fp=fopen(argv[1],"w"))==NULL)
    {
        printf("Unable to open file %s for writing.\n",argv[1]);

        exit(1);
    }

#if 0
    printf("file: %s\.n",argv[1]);
#endif

    sbmalloc();

    samplespersec=atoi(argv[2]);
#if 0
    printf("Samples Per Second %u.\n",samplespersec);
#endif
    tconst=time_const(samplespersec);

#if 0
    printf("Time Constant %u.\n",tconst);
#endif
    sbsettconst(tconst);

    sbrec(1,num);

    printf("Press enter to begin recording...press any key to end recording.");

    getchar();

    sbrec(BUF_SIZE,num);

    while(!done)
    {
	if (poll(sbpoll,2,-1)==1)
	{
		/* if key is hit */

		if (sbpoll[1].revents&POLLIN)
		{
			getchar();

			/* set done flag */

			done=1;

			/* wait for end of recording */

			poll(sbpoll,1,-1);
		}
	}
	else
	{
		getchar();

		done=1;
	}

	/* if we are still recording, start doing the next buffer full */

	if (!done)
    		sbrec(BUF_SIZE,(num==1)?0:1);

	fwrite((num==0)?aligned0:aligned1,1,BUF_SIZE,fp);

	num=(num==0)?1:0;
    }

    close(sb_fd);

    fclose(fp);
}

sbmalloc()
{
	aligned0=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned0==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned0)%PAGE_SIZE)
		aligned0+=PAGE_SIZE-(((unsigned long)aligned0)%PAGE_SIZE);

	aligned1=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned1==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned1)%PAGE_SIZE)
		aligned1+=PAGE_SIZE-(((unsigned long)aligned1)%PAGE_SIZE);

	sbis.buffer_addr=aligned0;
	sbis.buffer_len=BUF_SIZE;

	errno=0;

	ioctl(sb_fd,MAP_BUFFER0,&sbis);

	if (errno)
	{
		printf("Error %d on map 0.\n",errno);

		exit(5);
	}

	sbis.buffer_addr=aligned1;
	
	errno=0;

	ioctl(sb_fd,MAP_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d on map 1.\n",errno);

		exit(5);
	}
}

sbsettconst(val)
unsigned char val;
{
	sbis.parameter=val;

	ioctl(sb_fd,SET_TIMECONST,&sbis);
}

sbspkon()
{
	ioctl(sb_fd,SPKR_ON,&sbis);
}

sbspkoff()
{
	ioctl(sb_fd,SPKR_OFF,&sbis);
}

sbhaltdma()
{
	ioctl(sb_fd,DMA_HALT,&sbis);
}

sbplay(len,bufnum)
unsigned long len;
int bufnum;
{
	sbis.buffer_len=len;

	/* printf("len %ld\n",len); */

	errno=0;

	ioctl(sb_fd,(bufnum==0)?PLAY_BUFFER0:PLAY_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d playing %d.\n",errno,bufnum);

		sbspkoff();

		exit(5);
	}
}

dmastatus()
{
	sbis.status=&sb_status;

	ioctl(sb_fd,DMA_STATUS,&sbis);

	printf("%d\n",sb_status&2);

	return (sb_status&2);
}

sbrec(len,bufnum)
unsigned long len;
int bufnum;
{
	sbis.buffer_len=len;

	/* printf("len %ld\n",len); */

	errno=0;

	ioctl(sb_fd,(bufnum==0)?RECORD_BUFFER0:RECORD_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d recording %d.\n",errno,bufnum);

		sbspkoff();

		exit(5);
	}
}
