/*
   Copyright (c) 1994 by Harry Pulley.

   May be freely distributed and modified provided that this copyright notice
   is not removed.  I am not responsible for any damages caused in any way,
   shape or form.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <fcntl.h>
#include <poll.h>
#include <sys/sbioctl.h>

void mywave();

char *bigbuf,*bigptr;

int delay;
int sb_fd;
struct sb_ioctl sbis;
unsigned char sb_status;
struct pollfd sbpoll[1];

unsigned char tconst;
unsigned long buflen;
FILE *fp;
unsigned char gstring[80];

char *aligned0,*aligned1;

unsigned riffid;
unsigned rifflen;
unsigned widid;
unsigned formatid;
unsigned formatlen;
unsigned formatnext;
unsigned short widformattag;
unsigned short numchan;
unsigned short samplespersec;
unsigned short avgbytespersec;
unsigned dataid;
unsigned datalen,master_datalen;

main(argc,argv)
int argc;
char **argv;
{
	if (argc!=2)
	{
		printf("Usage: %s <filename>.\n",argv[0]);

		exit(0);
	}

	mywave(argv[1]);
}

void mywave ( filename )
char *filename;
{
    int num=0;

    sb_fd=open("/dev/sb",O_RDWR);

    if (sb_fd<0)
    {
	printf("Unable to open SB driver.\n");

	exit(4);
    }

    sbpoll[0].fd=sb_fd;
    sbpoll[0].events=POLLOUT;

    sbmalloc();

    if((fp=fopen(filename,"r"))==NULL)
    {
	printf("Unable to open %s for reading.\n",filename);

        exit(4);
    }
    
    fread(&riffid,1,4,fp);
    fread(&rifflen,1,4,fp);
    fread(&widid,1,4,fp);
    fread(&formatid,1,4,fp);
    if(riffid!=0x46464952||widid!=0x45564157||formatid!=0x20746D66)
    {
        printf("Incorrect file format.\n");
        exit(1);
    }

    fread(&formatlen,1,4,fp);
    formatnext=formatlen+ftell(fp);
    fread(&widformattag,1,2,fp);
    if(widformattag!=1)
    {
        printf("Data is not PCM.\n");
        exit(1);
    }

    fread(&numchan,1,2,fp);
    if(numchan!=1)
    {
        printf("Only mono .wav files supported.\n");
        exit(1);
    }

    fread(&samplespersec,1,2,fp);
    fread(&avgbytespersec,1,2,fp);
    fseek(fp,formatnext,0);
    fread(&dataid,1,4,fp);
    if(dataid!=0x61746164)
    {
        printf("Not a DATA chunk\n");
        exit(1);
    }

    fread(&datalen,1,4,fp);
    master_datalen=datalen;

    bigbuf=malloc(master_datalen);

    if (bigbuf==NULL)
    {
	printf("Unable to allocate buffer.\n");

	exit(5);
    }

    bigptr=bigbuf;

    fread(bigbuf,1,master_datalen,fp);

    tconst=time_const(samplespersec);

    delay=1000*(BUF_SIZE)/samplespersec;
    delay-=delay%10;
#if 0
    printf("Time constant: %d Samples/sec.: %d Delay: %d.\n",tconst,samplespersec,delay);
#endif
    sbsettconst(tconst);

    if(datalen>BUF_SIZE) buflen=BUF_SIZE; else buflen=datalen;
    datalen-=buflen;
    memcpy(aligned0,bigptr,(unsigned long)buflen);
    bigptr+=BUF_SIZE;
    sbspkon();
    sbplay(1,num);
    sbspkoff();
    sbspkon();

    while(1)
    {
	sbplay(buflen,num);

        num=(num==1)?0:1;

	delay=1000*buflen/samplespersec;
	delay-=delay%10;

	if (datalen==0)
	{
		poll(sbpoll,1,-1);

		break;
	}
	else
	{
        	if(datalen>(BUF_SIZE)) buflen=(BUF_SIZE); else buflen=datalen;
        	datalen-=buflen;
		memcpy((num==1)?aligned1:aligned0,bigptr,buflen);
		bigptr+=(BUF_SIZE);
		poll(sbpoll,1,-1);
	}
    }
    sbspkoff();

    close(sb_fd);
}

sbmalloc()
{
	aligned0=(char *)malloc((long)BUF_SIZE+PAGE_SIZE-1);

	if (aligned0==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned0)%PAGE_SIZE)
		aligned0+=PAGE_SIZE-(((unsigned long)aligned0)%PAGE_SIZE);

	aligned1=(char *)malloc((long)BUF_SIZE+PAGE_SIZE-1);

	if (aligned1==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned1)%PAGE_SIZE)
		aligned1+=PAGE_SIZE-(((unsigned long)aligned1)%PAGE_SIZE);

	sbis.buffer_addr=aligned0;
	sbis.buffer_len=BUF_SIZE;

	errno=0;

	ioctl(sb_fd,MAP_BUFFER0,&sbis);

	if (errno)
	{
		printf("Error %d on map 0.\n",errno);

		exit(5);
	}

	sbis.buffer_addr=aligned1;
	
	errno=0;

	ioctl(sb_fd,MAP_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d on map 1.\n",errno);

		exit(5);
	}
}

sbsettconst(val)
unsigned char val;
{
	sbis.parameter=val;

	ioctl(sb_fd,SET_TIMECONST,&sbis);
}

sbspkon()
{
	ioctl(sb_fd,SPKR_ON,&sbis);
}

sbspkoff()
{
	ioctl(sb_fd,SPKR_OFF,&sbis);
}

sbhaltdma()
{
	ioctl(sb_fd,DMA_HALT,&sbis);
}

sbplay(len,bufnum)
unsigned long len;
int bufnum;
{
	sbis.buffer_len=len;

	errno=0;

	ioctl(sb_fd,(bufnum==0)?PLAY_BUFFER0:PLAY_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d playing %d.\n",errno,bufnum);

		sbspkoff();

		exit(5);
	}
}

dmastatus()
{
	sbis.status=&sb_status;

	ioctl(sb_fd,DMA_STATUS,&sbis);

	printf("%d\n",sb_status&2);

	return (sb_status&2);
}
