/* RWDOCS */
/* filename	: misc.c
 * Miscellaneous machine independent utilities 
 */

#include "global.h"
#include <ctype.h>

/* Convert hex-ascii to integer, doesn't allow signed conversion.
 * breaks at first non digit char. could use atoi insted.
 */
int
htoi(s)
char *s;
{

/* RWDOCE */
	int i = 0;
	char c;
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	while((c = *s++) != '\0'){
		if(c == 'x')
			continue;	/* allow 0x notation */
		if('0' <= c && c <= '9')
			i = (i * 16) + (c - '0');
		else if('a' <= c && c <= 'f')
			i = (i * 16) + (c - 'a' + 10);
		else if('A' <= c && c <= 'F')
			i = (i * 16) + (c - 'A' + 10);
		else
			break;
	}
	return i;
}

/* RWDOCS */
/* replace terminating end of line marker(s) with null. finds
 * first \r or \n and replaces it with \0. good function, but
 * call overhead is involved. Could involve namespace collision
 * with RIP protocol software.
 */
void
rip(s)
register char *s;
{

/* RWDOCE */
	register char *cp;
	char * index();
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	if((cp = index(s,'\r')) != NULLCHAR)
		*cp = '\0';
	if((cp = index(s,'\n')) != NULLCHAR)
		*cp = '\0';
}

/* RWDOCS */
/* Case-insensitive string comparison,
 * may not be needed in k level code.
 */
int strncasecmp(a,b,n)
register char *a,*b;
register int n;
{
/* RWDOCE */

	char a1,b1;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	while(n-- != 0 && (a1 = *a++) != '\0' && (b1 = *b++) != '\0'){
		if(a1 == b1)
			continue;	/* No need to convert */
		a1 = tolower(a1);
		b1 = tolower(b1);
		if(a1 == b1)
			continue;	/* NOW they match! */
		if(a1 > b1)
			return 1;
		if(a1 < b1)
			return -1;
	}
	return 0;
}

/* RWDOCS */
#ifdef COH42
/* Copy a string to a malloc'ed buffer. Contains a printf
 * if malloc fails. returns a pointer to the new buffer, or
 * NULL on error. caller is responsible for free()ing buffer.
 */
char *
strdup(s)
const char *s;
{
/* RWDOCE */
	register char *out;
	register int len;
	int printf();

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	if(s == NULLCHAR)
		return NULLCHAR;
	len = strlen(s);
	out = malloc(len+1);
	if (!out) {
		printf("strdup: malloc failed\n");
		exit(1);
	}
	/* This is probably a tad faster than strcpy, since we know the len */
	memcpy(out,s,len);
	out[len] = '\0';
	return out;
}
#endif /* COH42 */

/* RWDOCS */
/* get the value of a short from location cp. Alignment
 * insensitive. Could be used instead os pull16() if 
 * mbuf and counter are known to be valid.
 */
int32
get16(cp)
register char *cp;
{
/* RWDOCE */

	register int32 x;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	x = (*cp++ & 0xff);
	x <<= 8;
	x |= (*cp & 0xff);
	return (x & 0xffff);
}



