/* RWDOCS */
/* filename	: netuser.c
 * 
 * Miscellaneous format conversion subroutines
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "sokname.h"	/* for SOKNAME - N5OWK */
#include "global.h"
#include "netuser.h"

#ifdef UNIX
#include "unix.h"
#endif /* UNIX */

int net_error;

#define LINELEN 80

/* Convert Internet address in ascii dotted-decimal format (44.0.0.1) to
 * binary IP address. Doesn't handle leading '['. Uses atoi. Returns
 * the address as an int32
 */
int32
aton(s)
register char *s;
{

/* RWDOCE */
	int32 n;
	int atoi();
	register int i;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	n = 0;
	for(i=24;i>=0;i -= 8){
		n |= (int32)atoi(s) << i;
		if((s = index(s,'.')) == NULLCHAR)
		break;
		s++;
	}
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return n;
}

/* RWDOCS */
/* Resolve a host name into an IP address. IP addresses in dotted-decimal
 * notation are distinguished from domain names by enclosing them in
 * brackets, e.g., [44.64.0.1]. xresolve uses a linear search of
 * file hosts.net to perform translation. However, it will also 
 * resolve dotted decimal addresses.
 *
 * This function is called from domain's resolve() before resorting to
 * domain cache or internet domain name service. hosts.net is a
 * simple file and it can handle user defined aliases provided the
 * user can supply a dotted decimal address for the alias.
 *
 * returns a 0 if the name could not be resolved, else an ip
 * address is returned in binary format.
 * xresolve keeps an in core cache of previous resolutions.
 */
int32
xresolve(host)
char *host;
{

/* RWDOCE */
	register char *cp;
	int32 addr;
	char hostent[LINELEN];
	FILE *sfile;
	static struct {
		char *name;
		int32 address;
	} cache;
	void rip(), free();

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	if(*host == '['){
		/* Brackets indicate IP address in dotted-decimal form */
		return aton(host + 1);
	}
	if(isdigit(*host))
		{
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

		return aton(host);
		}
	if(cache.name != NULLCHAR && strcmp(cache.name,host) == 0)
		{
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return cache.address;
		}
	/* Not a numerical IP address, search the host table */
	if((sfile = fopen(hosts,"r")) == NULLFILE){
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return 0;
	}
	while (!feof(sfile)){
		fgets(hostent,LINELEN,sfile);
		rip(hostent);
		cp = hostent;
		if(*cp == '#' || !isdigit(*cp))
			continue;	/* Comment or invalid line */
		cp = strtok(cp," \t");
		addr = aton(cp);
		while(cp != NULLCHAR){
			cp = strtok(NULLCHAR," \t");
			if(strcmp(host,cp) == 0){
				/* Found it, put in cache */
				fclose(sfile);
				if(cache.name != NULLCHAR)
					free(cache.name);
				cache.name = malloc((unsigned)strlen(host)+1);
				strcpy(cache.name,host);
				cache.address = addr;
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
				return cache.address;
			}
			/* That one didn't match, try the next one */
		}
	}
	/* No address found */
	fclose(sfile);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}

/* RWDOCS */
/* Convert an internet address (in host byte order) to a dotted decimal ascii
 * string, e.g., 255.255.255.255\0
 */
char *
inet_ntoa(a)
int32 a;
{

/* RWDOCE */
	static char buf[16];
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	sprintf(buf,"%u.%u.%u.%u",
		hibyte(hiword(a)),
		lobyte(hiword(a)),
		hibyte(loword(a)),
		lobyte(loword(a)) );
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return buf;
}

/* RWDOCS */
/* Convert a socket (address + port) to an ascii string of the form
 * aaa.aaa.aaa.aaa:ppppp
 */
char *
psocket(s)
struct socket *s;
{

/* RWDOCE */
	static char buf[30];

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	sprintf(buf,"%s:%u",inet_ntoa(s->address),s->port);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return buf;
}

/* RWDOCS */
#ifdef SOKNAME
/* Convert a socket (address + port) to an ascii string of the form
 * n5owk.okla.ampr:pppppppp
 */

#define POSITION 2	/* position of returned label in hosts.net file */
char *
puname(s)
struct socket *s;
{

/* RWDOCE */
	register int i;
	static char buf[25];			/* printf in caller only will do 24 chars */
	char	*cp, *cpt,*psocket();  	/* but that would leave no space between */
	char	hostent[LINELEN];		/* port and next field so shortened return */
	FILE	*sfile;              /* string by one character below */
	char *tcp_port();
	extern int issok;
	void rip();

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	cpt = NULLCHAR;

	if(issok){	/* it may be turned off by sokname command */
	strncpy(buf,inet_ntoa(s->address),16);
	i = strlen(buf);
	if ((sfile = fopen(hosts,"r")) == NULLFILE)
		{
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return NULLCHAR;
		}

	while (!feof(sfile)){
		fgets(hostent,LINELEN,sfile);

		if(hostent[0] == '#' || !isdigit(hostent[0]))
			continue;	/* Comment or invalid line */
		if(strncmp(buf,hostent,i) != 0)	/* this requires IP address be */
			continue;			/* left justified in file */
		fclose(sfile);
		rip(hostent);
		cp = hostent;
		for(i = 0,cp = strtok(cp," \t");cp != NULLCHAR && i < POSITION;i++){
			cpt = cp;
			cp = strtok(NULLCHAR," \t");
		}
		if(cp == NULLCHAR)
			cp = cpt;
		cp[15] = '\0';	/* in case cp was gross - size restricted for */
		sprintf(buf,"%s:%s", cp, tcp_port(s->port)); /* screen cosmetics */
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return buf;		/* in tcpcmd.c, port is max of 8 chars */
	}

	/* No address found */
	fclose(sfile);
	}
	cp = psocket(s);	/* punt, never heard of em - or sokname may be off */
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return cp;
}
#endif


/* RWDOCS */
/* Convert hex-ascii string to long integer */
long
htol(s)
char *s;
{

/* RWDOCE */
	long ret;
	char c;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	ret = 0;
	while((c = *s++) != '\0'){
		if(c >= '0' && c <= '9')
			ret = ret*16 + (c - '0');
		else if(c >= 'a' && c <= 'f')
			ret = ret*16 + (10 + c - 'a');
		else if(c >= 'A' && c <= 'F')
			ret = ret*16 + (10 + c - 'A');
		else
			break;
	}

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return ret;
}
