/* RWDOCS */
/* filename	: udp.h
 * purpose	: User Datagram Protocol definitions 
 */
#ifndef UDP_H
#define UDP_H

#include "internet.h"
#define	NUDP	20

/* Structure of a UDP protocol header */
struct udp {
	int32 source;	/* Source port */
	int32 dest;	/* Destination port */
	int32 length;	/* Length of header and data */
	int32 checksum;	/* Checksum over pseudo-header, header and data */
};
#define	UDPHDR	8	/* Length of UDP header */

/* User Datagram Protocol control block
 * Each entry on the receive queue consists of the
 * remote socket structure, followed by any data
 */
struct udp_cb {
	struct udp_cb *prev;	/* Linked list pointers */
	struct udp_cb *next;
	struct socket socket;	/* Local port accepting datagrams */
	void (*r_upcall)();	/* Function to call when one arrives */
	struct mbuf *rcvq;	/* Queue of pending datagrams */
	int rcvcnt;		/* Count of pending datagrams */
};
extern struct udp_cb *udps[];	/* Hash table for UDP structures */
#define	NULLUDP	(struct udp_cb *)0

/* UDP statistics counters */
struct udp_stat {
	int32 rcvd;		/* Packets received */
	int32 sent;		/* Packets sent */
	int32 cksum;		/* Checksum errors */
	int32 unknown;		/* Unknown socket */
	int32 bdcsts;		/* Incoming broadcasts */
};

/* UDP primitives */
#ifdef GCC
int open_udp(struct socket *lsocket,void (*r_upcall)() );
int send_udp(struct socket *lsocket,struct socket *fsocket,int tos,int ttl,struct mbuf *data,int length,int id,int df);
int recv_udp(struct socket *lsocket,struct socket *fsocket,struct mbuf **bp);
int del_udp(struct socket *lsocket);
void udp_input(struct mbuf *bp,int protocol,int32 source,int32 dest,int tos,int length,int rxbroadcast);
struct mbuf *htonudp(struct udp *udp,struct mbuf *data,struct pseudo_header *ph);
void ntohudp(struct udp *udp,struct mbuf **bpp);
#else
int open_udp(),recv_udp(),send_udp(),del_udp();
void udp_dump(), ntohudp();
struct mbuf *htonudp();
#endif /* GCC */

#endif /* UDP_H */
/* RWDOCE */
