#
/*
 */

#include "../manifest.h"
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"
#include "../buf.h"
#include "../reg.h"
#include "../inode.h"
#include "../370.h"
#define MAGIC1 #47f00020
#define MAGIC2	#47f00024
#define HDRLEN	32

/*
 * exec system call.
 * Because of the fact that an I/O buffer is used
 * to store the caller's arguments during exec,
 * and more buffers are needed to read in the text file,
 * deadly embraces waiting for free buffers are possible.
 * Therefore the number of processes simultaneously
 * running in exec has to be limited to NEXEC.
 */
#define EXPRI	-1

exec()
{
	int ap, na, nc, *bp;
	int ts, ds, sep;
	int c, *ip;
	char *cp;
	extern uchar;

	/*
	 * pick up file names
	 * and check various modes
	 * for execute permission
	 */

	ip = namei(&uchar, 0);
	if(ip == NULL)
		return;
	while(execnt >= NEXEC)
		sleep(&execnt, EXPRI);
	execnt++;
	bp = getblk(NODEV);
	if(access(ip, IEXEC) || (ip->i_mode&IFMT)!=0)
		goto bad;

	/*
	 * pack up arguments into
	 * allocated disk buffer
	 */

	cp = bp->b_addr;
	na = 0;
	nc = 0;
	while(ap = fuword(u->u_arg[1])) {
		na++;
		if(ap == -1)
			goto bad;
		u->u_arg[1] =+ 4;
		for(;;) {
			c = fubyte(ap++);
			if(c == -1)
				goto bad;
			*cp++ = c;
			nc++;
			if(nc > BLKSIZE - WORDSIZE) {
				u->u_error = E2BIG;
				goto bad;
			}
			if(c == 0)
				break;
		}
	}
	if((nc&1) != 0) {
		*cp++ = 0;
		nc++;
	}

	/*
	 * read in first 16 bytes
	 * of file for segment
	 * sizes:
	 * w0 = magic number (MAGIC1 is normal) ( MAGIC2 is RO text)
	 * w1 = text size
	 * w2 = data size
	 * w3 = bss size
	 */

	u->u_base = &u->u_arg[0];
	u->u_count = 16;
	u->u_offset = 0;
	u->u_segflg = 1;
	readi(ip);
	u->u_segflg = 0;
	if(u->u_error)
		goto bad;
	sep = 0;
	if(u->u_arg[0] == MAGIC1) {
		u->u_arg[2] =+ u->u_arg[1];
		u->u_arg[1] = 0;
	} else
	if(u->u_arg[0] != MAGIC2) {
		u->u_error = ENOEXEC;
		goto bad;
	}
	if(u->u_arg[1]!=0 && (ip->i_flag&ITEXT)==0 && ip->i_count!=1) {
		u->u_error = ETXTBSY;
		goto bad;
	}

	/*
	 * find text and data sizes
	 * try them out for possible
	 * exceed of max sizes
	 */

	ts = ((u->u_arg[1]+PGSIZE-1)/PGSIZE) & PGMASK;
	ds = ((u->u_arg[3]+u->u_arg[2]+PGSIZE-1)/PGSIZE) & PGMASK;
	if(ts+ds+SSIZE > maxmem) goto bad;

	/*
	 * allocate and clear core
	 * at this point, committed
	 * to the new image
	 */

	u->u_prof[3] = 0;
	xfree();
	xalloc(ip);
	estabur(ds,SSIZE);
	protect(u->u_dpages,1);
	protect(u->u_spages,1);
	sureg();

	/*
	 * read in data segment
	 */

	u->u_base = 0;
	u->u_offset = HDRLEN + u->u_arg[1];
	u->u_count = u->u_arg[2];
	readi(ip);

	/*
	 * initialize stack segment
	 */

	u->u_tsize = ts;
	u->u_dsize = ds;
	u->u_ssize = SSIZE;
	cp = bp->b_addr;
	ap = (-(nc+na*4+8)) & ~3;
	u->u_arsp[R13] = ap;
	suword(ap, na);
	c = -nc;
	while(na--) {
		suword(ap=+4, c);
		do
			subyte(c++, *cp);
		while(*cp++);
	}
	suword(ap+4, -1);

	/*
	 * set SUID/SGID protections, if no tracing
	 */

	if ((u->u_procp->p_flag&STRC)==0) {
		if(ip->i_mode&ISUID)
			if(u->u_uid != 0) {
				u->u_uid = ip->i_uid;
				u->u_procp->p_uid = ip->i_uid;
			}
		if(ip->i_mode&ISGID)
			u->u_gid = ip->i_gid;
	}

	/*
	 * clear sigs, regs and return
	 */

	c = ip;
	for(ip = &u->u_signal[0]; ip < &u->u_signal[NSIG]; ip++)
		if((*ip & 1) == 0)
			*ip = 0;
	for(ip=u->u_orega+2;ip<u->u_orega+13;ip++) *ip = 0;
	u->u_arsp[R0]=u->u_arsp[R1]=u->u_arsp[R14]=u->u_arsp[R15] = 0;
	for(ip = &u->u_fsav[0]; ip < &u->u_fsav[8]; ip++) *ip = 0;
	u->u_arsp[RPC] = 0;
	ip = c;

bad:
	iput(ip);
	brelse(bp);
	if(execnt >= NEXEC)
		wakeup(&execnt);
	execnt--;
}

/*
 * exit system call:
 * pass back caller's r0
 */
rexit()
{

	u->u_arg[0] = u->u_arsp[R0] << 8;
	exit();
}

/*
 * Release resources.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit()
{
	register int *q, a;
	register struct proc *p;

	u->u_procp->p_flag =& ~STRC;
	for(q = &u->u_signal[0]; q < &u->u_signal[NSIG];)
		*q++ = 1;
	for(q = &u->u_ofile[0]; q < &u->u_ofile[NOFILE]; q++)
		if(a = *q) {
			*q = NULL;
			closef(a);
		}
	iput(u->u_cdir);
	xfree();
	q = u->u_procp;
	q->p_utime =+ u->u_cutime;
	q->p_textp = u->u_arg[0];
	freesgs(u->u_dpages);
	freesgs(u->u_spages);
	q->p_addr = u->u_cstime;
	q->p_stat = SZOMB;

loop:
	for(p = &proc[0]; p < &proc[NPROC]; p++)
	if(q->p_ppid == p->p_pid) {
		wakeup(&proc[1]);
		wakeup(p);
		for(p = &proc[0]; p < &proc[NPROC]; p++)
		if(q->p_pid == p->p_ppid) {
			p->p_ppid  = 1;
			if (p->p_stat == SSTOP)
				setrun(p);
		}
		swtch();
		/* no return */
	}
	q->p_ppid = 1;
	goto loop;
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
	register f, *bp;
	register struct proc *p;

	f = 0;

loop:
	for(p = &proc[0]; p < &proc[NPROC]; p++)
	if(p->p_ppid == u->u_procp->p_pid) {
		f++;
		if(p->p_stat == SZOMB) {
			u->u_arsp[R0] = p->p_pid;
			u->u_arsp[R1] = p->p_textp;
			p->p_textp = 0;
			u->u_cstime =+ p->p_addr;
			u->u_cutime =+ p->p_utime;
			p->p_stat = NULL;
			p->p_pid = 0;
			p->p_ppid = 0;
			p->p_sig = 0;
			p->p_ttyp = 0;
			p->p_flag = 0;
			return;
		}
		if(p->p_stat == SSTOP) {
			if((p->p_flag&SWTED) == 0) {
				p->p_flag =| SWTED;
				u->u_arsp[R0] = p->p_pid;
				u->u_arsp[R1] = (p->p_sig<<8) | 0177;
				return;
			}
			p->p_flag =& ~(STRC|SWTED);
			setrun(p);
		}
	}
	if(f) {
		sleep(u->u_procp, PWAIT);
		goto loop;
	}
	u->u_error = ECHILD;
}


/*
 * fork system call.
 */
fork()
{
	register struct proc *p1, *p2;

	p1 = u->u_procp;
	for(p2 = &proc[0]; p2 < &proc[NPROC]; p2++)
		if(p2->p_stat == NULL)
			goto found;
	u->u_error = EAGAIN;
	goto out;

found:
	if(newproc()) {
		u->u_arsp[R0] = p1->p_pid;
		u->u_cstime = 0;
		u->u_stime = 0;
		u->u_cutime = 0;
		return;
	}
	u->u_arsp[R0] = p2->p_pid;

out:
	u->u_arsp[RPC] =+ 4;
}

/*
 * break system call.
 *  -- bad planning: "break" is a dirty word in C.
 */
sbreak()
{
	register n, d;

	/*
	 * set n to new data size
	 * set d to new minus old
	 */

	n = ((u->u_arg[0]+PGSIZE-1)/PGSIZE) & PGMASK;
	n =- u->u_tsize;
	d = n - u->u_dsize;
	sbreak1(d); /* call asm routine to do the dirty work */
	sureg();

}
