#
/* C compiler  (file c03.c)

Copyright 1972 Bell Telephone Laboratories, Inc.

*/

#include "c0h.c"

#define	forsps	150

forstmt()
{
	int l, savxpr[forsps];
	int *st, *ss;
	register int *sp1, *sp2, o;

	if ((o=symbol()) != LPARN)
		return(o);
	if ((o=symbol()) != SEMI) {		/* init part */
		peeksym = o;
		rcexpr0(tree(), efftab);
		if ((o=symbol()) != SEMI)
			return(o);
	}
	label(contlab);
	if ((o=symbol()) != SEMI) {		/* test part */
		peeksym = o;
		rcexpr0(block(1,CBRANCH,tree(),brklab,0), cctab);
		if ((o=symbol()) != SEMI)
			return(o);
	}
	if ((peeksym=symbol()) == RPARN) {	/* incr part */
		peeksym = -1;
		statement(0);
		branch(contlab);
		return(0);
	}
	l = contlab;
	contlab = isn++;
	st = tree();
	if ((o=symbol()) != RPARN)
		return(o);
	ss = space;
	if (space-treebase > forsps) {
		error("Expression too large");
		space = &treebase[forsps];
	}
	sp2 = savxpr;
	for (sp1=treebase; sp1<space;)
		*sp2++ = *sp1++;
	statement(0);
	space = ss;
	sp2 = savxpr;
	for (sp1=treebase; sp1<space;)
		*sp1++ = *sp2++;
	label(contlab);
	rcexpr0(st, efftab);
	branch(l);
	return(0);
}

pexpr()
{
	register o, t;

	if ((o=symbol())!=LPARN)
		goto syntax;
	t = tree();
	if ((o=symbol())!=RPARN)
		goto syntax;
	return(t);
syntax:
	error("Statement syntax");
	errflush(o);
	return(0);
}

pswtch0()
{
	int *sswp, swlab;
	register int *swb, dl;

	swb = sswp = swp;
	if (swp==0)
		swb = swp = swtab;
	branch(swlab=isn++);
	dl = deflab;
	deflab = 0;
	statement(0);
	if (!deflab)
		deflab = brklab;
	branch(brklab);
	label(swlab);
	pswitch(swb, swp);
	label(brklab);
	deflab = dl;
	swp = sswp;
}

decref(at)   /*  called when a pointer is applied  */
{
	register t;

	t = at;
	if ((t & ~07) == 0) {
		error("Illegal indirection");
		return(t);
	}
	return((t>>2) & ~07 | t&07);
}

incref(t)   /*  given type int, returns type pointer to int.  */
{
	return((t<<2)&~034 | (t&07) | PTR);
}

                           /*  Given a tree labeled true or false, it  */
cbrnch0(tree, lbl, cond)   /*  generates conditional transfers to a tree label  */
struct tnode *tree;        /*  depending on logic value.*/
{
	rcexpr0(block(1,CBRANCH,tree,lbl,cond),cctab);
}

rcexpr0(tree, table)  /* Call functions that will evaluate an expression.  */
struct table *table;
struct tnode *tree;
{
	if (tree == 0)
		return;
	tree = optim(tree);
	nstack = 0;
	rcexpr(tree, table, lowreg);
}

branch(lab) {   /*  Put out a branch instruction.  */
	printf("	B	$%d \n", lab);
}

label(l) {   /*  Puts out a label.  */
	printf("$%d	equ	* \n", l);
}

plength(ap)   /*  Arguement is a node containing a pointer.  */
struct tname *ap;   /*  Plength is length of thing pointed to.  */
{
	register t, l;
	register struct tname *p;

	p = ap;
	if (((t=p->ntype)&~07) == 0)		/* not a reference */
		return(1);
	p->ntype = decref(t);
	l = length(p);
	p->ntype = t;
	return(l);
}

length(acs)   /*  length in bytes of a thing.  */
struct tnode *acs;
{
	register t, n;
	register struct tnode *cs;

	cs = acs;
	t = cs->type;
	n = 1;
	while ((t&030) == ARRAY) {
		t = decref(t);
		n = dimtab[cs->ssp];
	}
	if ((t&~07)==FUNC)
		return(0);
	if (t>=PTR)
		return(4*n);
	switch(t&07) {

	case INT:
		return(4*n);

	case CHAR:
		return(n);

	case FLOAT:
		return(4*n);

	case DOUBLE:
		return(8*n);

	case STRUCT:
		return(n * dimtab[cs->lenp]);

	case RSTRUCT:
		error("Bad structure");
		return(0);
	}
	error("Compiler error (length)");
	return(0);
}

rlength(cs)   /*  same, but does rounding - allignment required.  */
struct tnode *cs;
{
	return((length(cs) + 03) & ~03);	/* round up to multiple of four. */
}

simplegoto()
{
	register struct hshtab *csp;

	if ((peeksym=symbol())==NAME && nextchar()==';') {
		csp = csym;
		if (csp->hclass==0 && csp->htype==0) {
			csp->htype = ARRAY;
			if (csp->hoffset==0)
				csp->hoffset = isn++;
		}
		if ((csp->hclass==0||csp->hclass==STATIC)
		 &&  csp->htype==ARRAY) {
			peeksym = -1;
			return(csp->hoffset);
		}
	}
	return(0);
}

nextchar()   /*  Peek ahead, but skip over spaces.  */
{
	while (getctab(peekc)==SPACE)
		peekc = getchar();
	return(peekc);
}

chconbrk(l)   /*  check continue and break  */
{
	if (l==0)
		error("Break/continue error");
}

dogoto()   /*  does the jump in general goto case.  */
{
	register struct tnode *np;

	*cp++ = tree();
	build(STAR);
	chkw(np = *--cp);
	rcexpr0(block(1,JUMP,0,0,np), regtab);
}

doret()   /*  Perform a RETURN statement.  */
{
	if (nextchar() != ';')
		rcexpr0(block(1, RFORCE, 0, 0, tree()), regtab);
	branch(retlab);
}


doasm()	/* Process Assembly Language Window (ASM) */
	/* asm("....."); is format, where text inside"-s is laid down
	exactly as is. */

{
	char a;

	if(symbol() != LPARN) goto asmerr ;
	if(getchar() != '"') goto asmerr ;
	while ((a=getchar()) != '"') {putchar(a);  }

	printf("\n");
	if(getchar() != ')') goto asmerr;
	return(0);

asmerr: error("asm delimiter error");
	return(-1);
}

hgprloc(hglocval) int hglocval; {
	if (hglocval == hgcurloc) return;
	switch (hglocval) {
		case hgmain: {
			printf("	mainloc\n");
			break;
		}
		case hgcode: {
			printf("	codeloc\n");
			break;
		}
		case hgdata: {
			printf("	dataloc\n");
			break;
		}
		case hgstring: {
			printf("	strgloc\n");
			break;
		}
		case hgtvec: {
			printf("	tvecloc\n");
			break;
		}
		case hglit: {
			printf("	litloc\n");
			break;
		}
		case hgistring: {
			printf( "	istrloc\n" );
			break;
			}
		default:
			error("Illegal loctr value");
	}
	hgcurloc = hglocval;
	return;
}
