#
#include "../manifest.h"
#include "../param.h"
#include "../user.h"
#include "../systm.h"
#include "../proc.h"
#include "../inode.h"
#include "../370.h"
#define ICODESZ	40	/* byte size of icode */

/*
 * Icode is the bootstrap
 * program executed in user mode
 * to bring up the system.
 */
extern int icode[];
/*
 * Initialization code.
 * Called from m370.a as soon as stack
 * has been established.
 * Functions:
 *	start the clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to scheduler
 *	     - process 1 execute bootstrap
 *
 * loop at loc 6 in user mode -- /etc/init
 *	cannot be executed.
 */
#define DROPSIZE 17	/* # words stack is dropped by on entry */
main370(dummy)
{

	printf("Unix/370\n");
	printf("Storage = %dk\n",(memlim+1)/1024);
	printf("%d free pages\n", maxmem);
	pagecnt = maxmem;
	/*
	 * start clock
	 */

	clkstrt();

	/*
	 * set up system process
	 */

	proc[0].p_addr = u;
	proc[0].p_stat = SRUN;
	proc[0].p_flag =| SLOAD|SSYS;
	u->u_procp = &proc[0];
	u->u_orega = (&dummy) - DROPSIZE;	/* for fixstak */

	/*
	 * set up 'known' i-nodes
	 */

	paginit();
	cinit();
	binit();
	iinit();
	rootdir = iget(rootdev, ROOTINO);
	rootdir->i_flag =& ~ILOCK;
	u->u_cdir = iget(rootdev, ROOTINO);
	u->u_cdir->i_flag =& ~ILOCK;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if(newproc()) {
		estabur(1,0);
		sureg();
		copyout(icode, 0, ICODESZ);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return;
	}
	sched();
}

estabur(ds,ss)
{
	freesgs(u->u_dpages);
	freesgs(u->u_spages);
	u->u_dpages = u->u_spages = 0;
	u->u_dsize = u->u_ssize = 0;
	if(ds > 0) sbreak1(ds);
	if(ss > 0) grow1(ss);
	u->u_dsize = ds;
	u->u_ssize = ss;
}

/*
 * Scheduling routine.
 * No scheduling for now,
 * so just sleep forever.
 */

sched()
{
	for(;;) sleep(sched,-1);
}
