#
/*
 * (3340) disk driver
 */

#include	"../manifest.h"
#include	"../param.h"
#include	"../370.h"
#include	"../conf.h"
#include	"../user.h"	/* for appropriate errors */
#include	"../buf.h"
#include	"../dsk.h"
#define	DSKBLKS	1428	/* 10 cyls of 3340 - track 0 */

dskopen(majmin,direction)
{
	struct	devdesc	*ddp;

	ddp = bdevsw[majmin.d_major].d_tab->dd_ptr;
	if (ddp->d_init) return;
	ddp->d_init++;
	ddp->d_maxblk = DSKBLKS;
 /*
  * Actually, I wanted to find out the blocks on the (mini) disk
  * and not hard code a constant... Also, the channel program would
  * be copied and linked together, requiring the dskio subroutine to
  * simply zap a bit or two...
  */
	ddp->d_devadr = bdevsw[majmin.d_major].d_baseaddr;
	ddp->d_curcyl = ddp->d_direct = 0;
}

dskstrategy(bp)
struct	buf	*bp;
{
	struct	devtab	*dtp;
	int	oldsm;
	dtp = bdevsw[bp->b_dev.d_major].d_tab;

	if (bp->b_blkno > dtp->dd_ptr->d_maxblk) {
		bp->b_flags =| B_ERROR;
		iodone(bp);
		return;
	}

	oldsm = stnsm(~ALLINT);
	if (dtp->d_actf == 0)
		dtp->d_actf = bp;
	else
		dtp->d_actl->av_forw = bp;

	bp->av_forw = 0;
	dtp->d_actl = bp;
	if (dtp->d_active == 0)
		dskstart(dtp);
 
	setsm(oldsm);
}

dskstart(dtp)
struct	devtab	*dtp;
{
	struct	dskdesc	*dskdsc;
	struct	devdesc	*devdsc;
	struct	buf	*bp;
	int	cc,hh,xr,sector,tmp;

	devdsc = dtp->dd_ptr;

	if ((bp = dtp->d_actf) == 0) return;
	dskdsc =  &dskdesc[bp->b_dev.d_minor];
	dtp->d_active++;  /* note that queue is active */
	xr = ((tmp = bp->b_blkno)%dskdsc->d_blktrk)+1;
	tmp = tmp/dskdsc->d_blktrk+1; /* skip first record and track */
	hh = tmp%dskdsc->d_trkcyl;
	cc = tmp/dskdsc->d_trkcyl;
	sector = (dskdsc->d_const+(xr-1)*dskdsc->d_factor)/dskdsc->d_divsor;
	dskio(devdsc,bp,cc,hh,xr,sector);
}

/*
 * interrupt routine which recieves control in disabled state.
 */
dskintr(majmin)
{
	struct	devtab	*dtp;
	struct	buf	*bp;

	dtp = bdevsw[majmin.d_major].d_tab;
	if (dtp->d_active == 0) {
		printf("dsk: unsolicited interrupt %x\n",IOADDR->integ);
		return;
	}

	bp = dtp->d_actf;

	if (CSW->unitstat&(ATTENTION|BUSY|UNITCHEK|UNITEXCP))
		panic("dsk: unit stat");
	if (CSW->chanstat)
		panic("dsk: chan stat");

	if (CSW->unitstat&DEVEND == 0)
		return; /* wait for device end */

	dtp->d_active = 0;
	dtp->d_actf = bp->av_forw;
	iodone(bp);
	if (dtp->d_actf) dskstart(dtp);
}

nointr(parm)
{
	printf("no iolkptab entry: %x\n",IOADDR->integ);
}
