#
#include "../manifest.h"
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"
#include "../370.h"

#define	SCHMAG	10
char clokwork 0;

/*
 * clock is called straight from
 * the real time clock interrupt.
 *
 * Functions:
 *	reprime clock
 *	implement callouts
 *	maintain user/system times
 *	maintain date
 *	profile
 *	tout wakeup (sys sleep)
 *	lightning bolt wakeup (every 4 sec)
 *	alarm clock signals
 */
clock(rsp,r14,r15,r0,r1,ps,pc)
{
	register struct callo *p1, *p2;
	register struct proc *pp;
	int s;

	/*
	 * restart clock
	 */

	clkstrt();

	/*
	 * callouts
	 * if none, just return
	 * else update first non-zero time
	 */

	if(callout[0].c_func == 0)
		goto out;
	p2 = &callout[0];
	while(p2->c_time<=0 && p2->c_func!=0)
		p2++;
	p2->c_time--;

	/*
	 * if ps is high, just return
	 */

	if((ps&ALLINT) != ALLINT)
		goto out;

	/*
	 * callout
	 */

	s = stnsm(~IOINT);
	if(callout[0].c_time <= 0) {
		p1 = &callout[0];
		while(p1->c_func != 0 && p1->c_time <= 0) {
			(*p1->c_func)(p1->c_arg);
			p1++;
		}
		p2 = &callout[0];
		while(p2->c_func = p1->c_func) {
			p2->c_time = p1->c_time;
			p2->c_arg = p1->c_arg;
			p1++;
			p2++;
		}
	}

	/*
	 * lightning bolt time-out
	 * and time of day
	 */

out:
	pp = u->u_procp;
	if((ps&UMODE) == UMODE) {
		++pp->p_utime;
		if(u->u_prof[3])
			incupc(pc, u->u_prof);
	} else
		u->u_stime++;
	if(++pp->p_cpu == 0)
		pp->p_cpu--;
	if(++lbolt >= HZ) {
		if(clokwork++ | ((ps&ALLINT) != ALLINT))
			return;
		lbolt =- HZ;
		/* ++time; */  /* now done in clkstrt */
		if(time==tout)
			wakeup(&tout);
		if((time&03) == 0) {
			runrun++;
			wakeup(&lbolt);
		}
		for(pp = &proc[0]; pp < &proc[NPROC]; pp++)
		if (pp->p_stat) {
			if(pp->p_time != 127)
				pp->p_time++;
			if((pp->p_cpu & 0377) > SCHMAG)
				pp->p_cpu =- SCHMAG; else
				pp->p_cpu = 0;
			if(pp->p_pri > PUSER)
				setpri(pp);
		}
		if((ps&UMODE) == UMODE) {
			u->u_arsp = &rsp;
			if(issig())
				psig();
			setpri(u->u_procp);
		}
		clokwork = 0;
	}
}

/*
 * timeout is called to arrange that
 * fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout
 * structure. The time in each structure
 * entry is the number of HZ's more
 * than the previous entry.
 * In this way, decrementing the
 * first entry has the effect of
 * updating all entries.
 */
timeout(fun, arg, tim)
{
	register struct callo *p1, *p2;
	register t;
	int s;

	t = tim;
	p1 = &callout[0];
	s = stnsm(~ALLINT);
	while(p1->c_func != 0 && p1->c_time <= t) {
		t =- p1->c_time;
		p1++;
	}
	p1->c_time =- t;
	p2 = p1;
	while(p2->c_func != 0)
		p2++;
	while(p2 >= p1) {
		(p2+1)->c_time = p2->c_time;
		(p2+1)->c_func = p2->c_func;
		(p2+1)->c_arg = p2->c_arg;
		p2--;
	}
	p1->c_time = t;
	p1->c_func = fun;
	p1->c_arg = arg;
	setsm(s);
}
