/ UNIX/v7m TM02/3 & TS11 1600 BPI magtape bootstrap
/ TM02/3 - only boots from unit 0.
/ TS11   - boots from unit 0 or 6 to allow
/	   for non standard addressing.
/
/ Thanks to Jerry Brenner for most of this code.
/
/ Fred Canter 4/30/81
/
/ ********************************************************
/ *							 *
/ * This bootstrap requires that the magtape CSR address *
/ * be in r1 on entry, the m9312 boot does this.         *
/ * If the value in r1 is outside the range of           *
/ * 0172520 - 0172554, boot from a TM02/3 is assumed.    *
/ * If this bootstrap fails to operate, manually load    *
/ * the magtape CSR address into r1, load address 137000 *
/ * octal, and start.					 *
/ *							 *
/ ********************************************************

/ tape boot program to load and transfer
/ the next item on the tape.

core = 24.
halt=0
.. = [core*2048.]-512.
start:
	mov	$..,sp
	mov	r1,r5
	mov	sp,r1
	cmp	pc,r1
	bhis	2f
	mov	r5,r2
	bic	$3,r2
	mov	r2,r3
	tst	(r3)+
	clr	r0
	cmp	(r0),$407
	bne	1f
	mov	$20,r0
1:
	mov	(r0)+,(r1)+
	cmp	r1,$core*2048.
	blo	1b
	jmp	(sp)

2:
/ If the CSR address in r1 is in the range
/ of 0172520 - 0172554, then the magtape is a TS11,
/ otherwise a TM02/3 magtape is assumed.
/ This is done in order to (hopefully) allow
/ the TM02/3 magtapes to be booted by any
/ hardware boot, even if it does not leave the
/ CSR address in r1.
/ The M9312, which is the only boot for the TS11,
/ leaves the CSR address in r1.

	cmp	r2,$172520
	blo	1f
	cmp	r2,$172554
	bhi	1f
	mov	$tsread,tread
	mov	$tsrew,rew
	br	2f
1:
	mov	$htrew,rew
	mov	$htread,tread
2:
	jsr	pc,*rew
	mov	$2,tapa
	mov	$-256.,wc
	jsr	pc,*tread

	mov	*$2,r0
	add	*$4,r0
	sub	$512.,r0
	asr	r0
	neg	r0
	bge	1f

	mov	r0,wc
	mov	$3,tapa
	mov	$512.,ba
	jsr	pc,*tread
1:
	jsr	pc,*rew
	clr	r0
	mov	$20,r1
	mov	sp,r4
	clc
	ror	r4
1:
	mov	(r1)+,(r0)+
	sob	r4,1b
	jsr	pc,*$0
	br	.

htcs1 = 172440
htba  = 172444
htfc  = 172446
htcs2 = 172450
htds  = 172452
httc  = 172472

P800 = 1300
P1600 = 2300
PIP = 20000
RESET = 40
MOL = 10000
ERR = 40000
REV = 33
READ = 71
REW = 7

htread:
1:
	mov	ba,mtma
	cmp	mtapa,tapa
	beq	1f
	bhi	2f
	jsr	pc,hrrec
	br	1b
2:
	jsr	pc,htrew
	br	1b
1:
	mov	wc,r1
1:
	jsr	pc,hrrec
	add	$256.,r1
	bmi	1b
	rts	pc

hrrec:
	mov	$htds,r0
	tstb	(r0)
	bpl	hrrec
	bit	$PIP,(r0)
	bne	hrrec
	bit	$MOL,(r0)
	beq	hrrec
	mov	$htfc,r0
	mov	$-512.,(r0)
	mov	mtma,-(r0)
	mov	$-256.,-(r0)
	mov	$READ,-(r0)
1:
	tstb	(r0)
	bpl	1b
	bit	$ERR,(r0)
	bpl	1f
	mov	$RESET,*$htcs2
	mov	$-1,*$htfc
	mov	$REV,(r0)
	br	hrrec
1:
	add	$512.,mtma
	inc	mtapa
	rts	pc

htrew:
	mov	$RESET,*$htcs2
	mov	$P1600,*$httc
	mov	$REW,*$htcs1
	clr	mtapa
	rts	pc


/(r2) is tsbuf
/(r3) is tssr

TSINIT = 140013
TSCHAR = 140004
TSREW  = 102010
TSREAD = 100001
TSRETRY = 100401

tsread:
1:
	mov	ba,mtma
	cmp	mtapa,tapa
	beq	1f
	bhi	2f
	jsr	pc,tsrrec
	br	1b
2:
	jsr	pc,tsrew
	br	1b
1:
	mov	wc,r1
1:
	jsr	pc,tsrrec
	add	$256.,r1
	bmi	1b
	rts	pc

tsrrec:
1:
	tstb	(r3)
	bpl	1b
	mov	$136006,r0
	mov	$512.,(r0)
	clr	-(r0)
	mov	mtma,-(r0)
	mov	$TSREAD,-(r0)
	mov	r0,(r2)
1:
	tstb	(r3)
	bpl	1b
	cmp	$1,(r3)
	blos	1f
	mov	$TSRETRY,(r0)
	mov	r0,(r2)
	br	1b
1:
	add	$512.,mtma
	inc	mtapa
	rts	pc

tsrew:
	jsr	pc,tsinit
	mov	$TSREW,136000
	mov	$136000,(r2)
	clr	mtapa
	rts	pc

tsinit:
	tstb	(r3)
	bpl	tsinit
	mov	$136000,r0
	mov	$TSCHAR,(r0)+
	mov	$136010,(r0)+
	clr	(r0)+
	mov	$10,(r0)+
	mov	r0,(r0)+
	clr	(r0)+
	mov	$16,(r0)+
	mov	$136000,(r2)
1:
	tstb	(r3)
	bpl	1b
	rts	pc
mtapa:	0
mtma:	0
tapa:	0
wc:	0
ba:	0
rew:	0
tread:	0
