#
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../reg.h"
#include "../file.h"
#include "../inode.h"
#include "../proc.h"

/*
 * The read system call. - 3.
 */
read()
{
	rdwr(FREAD);
}

/*
 * The write system call. - 4.
 */
write()
{
	rdwr(FWRITE);
}

/*
 * Common code for read and write calls:
 * check permissions, set base, count, and offset,
 * and switch out to readi, writei, or pipe code.
 * errors
 * EBADF: Attempted to do the wrong operation on the file.
 */
rdwr(mode)
{
	register *fp, m;

	m = mode;
	if ((fp = getf(u.u_ar0[R0])) == NULL)
		return;
	if(!(fp->f_flag & m)) {
		u.u_error = EBADF;
		return;
	}
	u.u_base = u.u_arg[0];
	u.u_count = u.u_arg[1];
	u.u_segflg = 0;
	if(fp->f_flag&FPIPE) {
		if(m==FREAD)
			readp(fp); else
			writep(fp);
	} else {
		u.u_offset[1] = fp->f_offset[1];
		u.u_offset[0] = fp->f_offset[0];
		if(m==FREAD)
			readi(fp->f_inode); else
			writei(fp->f_inode);
		dpadd(fp->f_offset, u.u_arg[1]-u.u_count);
	}
 /* protocol code... ##bsb 3-27-76
    */
	m = u.u_ar0[R0];
	u.u_ar0[R0] = u.u_arg[1]-u.u_count;
	if(m < NOFILE && u.u_pfile[m])
		proto(m + NOFILE);
}

/*
 * The open system call. - 5.
 */
open()
{
	register *ip;
	extern uchar;

	if ((ip = namei(&uchar, 0)) != NULL) {
		u.u_arg[1]++;
		open1(ip, u.u_arg[1], 0);
	}
}

/*
 * The creat system call. - 8.
 */
creat()
{
	register *ip;
	extern uchar;

	if((ip = namei(&uchar, 1)) == NULL) {
		if(!u.u_error)
/**rjb**/	if ((ip = maknode(u.u_arg[1]&05707)) != NULL)
			open1(ip, FWRITE, 2);
	} else
		open1(ip, FWRITE, 1);
}

/*
 * common code for open and creat.
 * Check permissions, allocate an open file structure,
 * and call the device open routine if any.
 * errors
 * EISDIR: Attempted to open a directory to write on it
 */
open1(ip, mode, trf)
int *ip;
{
	register struct file *fp;
	register *rip, m;
	int i;

	rip = ip;
	m = mode;
	if(trf != 2) {
		if(m&FREAD)
			access(rip, IREAD);
		if(m&FWRITE) {
			access(rip, IWRITE);
			if((rip->i_mode&IFMT) == IFDIR)
				u.u_error = EISDIR;
		}
	}
	if(!u.u_error) {
		if(trf)
			itrunc(rip);
		prele(rip);
		if ((fp = falloc()) != NULL) {
			fp->f_flag = m&(FREAD|FWRITE);
			fp->f_inode = rip;
			i = u.u_ar0[R0];
			openi(rip, m&FWRITE);
			if(!u.u_error)
				return;
			u.u_ofile[i] = NULL;
			fp->f_count--;
		}
	ilock(rip);	/*##stt 1/17/77 improve locking */
	}
	iput(rip);
}

/*
 * The close system call. - 6.
 */
close()
{
	register *fp;
	register fildes;

	fildes = u.u_ar0[R0];
	if ((fp = getf(fildes)) != NULL) {
		u.u_ofile[fildes] = NULL;
		closef(fp);
		/* ##stt 3/2/77 close proto handle also */
		fp = &u.u_pfile[fildes];
		if (*fp != NULL) {
			closef(*fp);
			*fp = NULL;
		}
	}
}

/*
 * The seek system call. - 19.
 * errors
 * ESPIPE: Attempt to seek on a pipe.
 */
seek()
{
	int n[2];
	register *fp, t;

	if ((fp = getf(u.u_ar0[R0])) == NULL)
		return;
	if(fp->f_flag&FPIPE) {
		u.u_error = ESPIPE;
		return;
	}
	t = u.u_arg[1];
	if(t > 2) {
		n[1] = u.u_arg[0]<<9;
		n[0] = u.u_arg[0]>>7;
		if(t == 3)
			n[0] =& 0777;
	} else {
		n[1] = u.u_arg[0];
		n[0] = 0;
		if(t!=0 && n[1]<0)
			n[0] = -1;
	}
	switch(t) {

	case 1:
	case 4:
		n[0] =+ fp->f_offset[0];
		dpadd(n, fp->f_offset[1]);
		break;

	default:
		n[0] =+ fp->f_inode->i_size0&0377;
		dpadd(n, fp->f_inode->i_size1);

	case 0:
	case 3:
		;
	}
	fp->f_offset[1] = n[1];
	fp->f_offset[0] = n[0];
}

/*
 * The link system call. - 9.
 * errors
 * EMLINK: Attempt to link to a file with the maximum number of links.
 * EEXIST: Attempt to link to a file which already exists.
 * EXDEV: Attempt to link across devices.
 */
link()
{
	register *ip, *xp;
	extern uchar;

	if ((ip = namei(&uchar, 0)) == NULL)
		return;
	if(ip->i_nlink >= 127) {
		u.u_error = EMLINK;
		goto out2;
	}
	if((ip->i_mode&IFMT)==IFDIR && !suser())
		goto out2;
	/*
	 * unlock to avoid possibly hanging the namei
	 */
	ip->i_flag =& ~ILOCK;
	u.u_dirp = u.u_arg[1];
	if ((xp = namei(&uchar, 1)) != NULL) {
		u.u_error = EEXIST;
		iput(xp);
	}
	if(!u.u_error) {
		if(u.u_pdir->i_dev != ip->i_dev) {
			iput(u.u_pdir);
			u.u_error = EXDEV;
			goto out1;
		}
		wdir(ip);
		ip->i_nlink++;
		ip->i_flag =| IACC;	/* was IUPD -- fh/bsb/stt */
	}
out1:
	ilock(ip);	/* ##stt 1/17/77 improve locking */
out2:
	iput(ip);
}

/*
 * The mknod system call (only su). - 14.
 */
mknod()
{
	register *ip;
	extern uchar;

	if(suser())
		if ((ip = namei(&uchar, 1)) != NULL) {
			u.u_error = EEXIST;
			goto out;
		}
	if (u.u_error || ((ip = maknode(u.u_arg[1])) == NULL))
		return;
	ip->i_addr[0] = u.u_arg[2];
out:
	iput(ip);
}

/*
 * The sleep system call. - 35.
 * not to be confused with the sleep internal routine.
 */
sslep()
{
	/* rewrite using longs ##stt 3/3/77 */
	long	d, d2;
	register struct pgrp *g;

	d.long0 = 0;
	d.long1 = u.u_ar0[R0];
	d =+ time - timeup;
	spl7();

	for (;;) {
		/* recalculating here allows time changes */
		/* without confusion */
		d2 = d + timeup;
		if (d2 <= time) break;
		if (tout <= time || tout > d2)
			tout = d2;
		sleep(&tout, PSLEP);
	}
	spl0();
}

