#
/*
 */

/*
 * RS03/04 disk driver
 */

#include "../param.h"
#include "../buf.h"
#include "../conf.h"
#include "../user.h"
#include "../st_his.h"


struct {
	int	rscs1;	/* Control and Status register 1 */
	int	rswc;	/* Word count register */
	int	rsba;	/* UNIBUS address register */
	int	rsda;	/* Desired address register */
	int	rscs2;	/* Control and Status register 2 */
	int	rsds;	/* Drive Status */
	int	rser;	/* Error register */
	int	rsas;	/* not used */
	int	rsla;	/* not used */
	int	rsdb;	/* not used */
	int	rsmr;	/* not used */
	int	rsdt;	/* not used */
	int	rsbae;	/* 11/70 bus extension */
};

struct	devtab	rstab;
struct	buf	rrsbuf;

#define	RSADDR	0172040
#define	NRSBLK	2048

#define ERR	0140000	/* rscs1 - composite error */

#define GO	01
#define RCLR	010
#define	DRY	0200	/* rsds - Drive Ready */

rsstrategy(abp)
struct buf *abp;
{
	register struct buf *bp;

	bp = abp;
	if (bp->b_blkno >= NRSBLK ||
	    bp->b_blkno + (((255 - bp->b_wcount)>>8 ) & 0377) > NRSBLK) {
		bp->b_flags =| B_ERROR;
/*		printf("bad blk- rs:%o c=%o %s\n", bp->b_blkno,
			bp->b_wcount,bp->b_flags&B_READ?"r":"w"); */
		iodone(bp);
		return;
	}
	bp->av_forw = 0;
	spl5();
	if (rstab.d_actf==0)
		rstab.d_actf = bp; else
		rstab.d_actl->av_forw = bp;
	rstab.d_actl = bp;
	if (rstab.d_active==0)
		rsstart();
	spl0();
}

rsstart()
{
	register struct buf *bp;
	register addr;

	if ((bp = rstab.d_actf) == 0)
		return;
	rstab.d_active++;
	st_word =| ST_RSBUSY;	/* set bit in state word */
	addr = bp->b_blkno;
	RSADDR->rscs2 = bp->b_dev.d_minor & 07;
	rhstart(bp, &RSADDR->rsda, addr<<1, &RSADDR->rsbae);
}

rsintr()
{
	register struct buf *bp;

	if (rstab.d_active == 0)
		return;
	bp = rstab.d_actf;
	rstab.d_active = 0;
	st_word =& ~ST_RSBUSY;	/* clear bit in state word */
	if(RSADDR->rscs1 & ERR){	/* error bit */
		deverror(bp, RSADDR->rscs2, RSADDR->rser);
		RSADDR->rscs1 = RCLR|GO;
		if (++rstab.d_errcnt <= 10) {
			rsstart();
			return;
		}
		bp->b_flags =| B_ERROR;
	}
	rstab.d_errcnt = 0;
	rstab.d_actf = bp->av_forw;
	iodone(bp);
	rsstart();
}

rsread(dev)
{

	physio(rsstrategy, &rrsbuf, dev, B_READ);
}

rswrite(dev)
{

	physio(rsstrategy, &rrsbuf, dev, B_WRITE);
}
