#
/*
 *	Copyright (C) 1974, The Children's Museum, Boston, MA 02130
 */


#
/*
 *	CR-11 Card Reader Driver
 *
 *	Author	Bill Mayhew
 *		The Children's Museum
 *		Jamaicaway
 *		Boston, MA 02130
 *		Phone (617) 522-4800
 */

#include	"../param.h"
#include	"../conf.h"
#include	"../user.h"

#define	CRADDR	0177160

#define	CLOSED	0
#define	WAITING	1
#define	READING	2
#define	EOF	3
#define CRERR	4

#define	RDRENB	01
#define	EJECT	02
#define	IENABLE	0100
#define	COLDONE	0200
#define	READY	0400
#define	BUSY	01000
#define	ONLINE	02000
#define	TIMERR	04000
#define	RDCHECK	010000
#define	PICKCHECK	020000
#define	CARDDONE	040000
#define	ERROR	0100000

#define	NLCHAR	0140
#define	EOFCHAR	07417

#define	CRPRI	10
#define	CRLOWAT	50
#define	CRHIWAT	82


struct {
	int crcsr;
	int crbuf1;
	int crbuf2;
};

struct clist {
	int cc;
	int cf;
	int cl;
};

struct cr11 {
	int crstate;
	struct clist crin;
	int crnch;
} cr11;

char asctab[]
{
	' ','1','2','3','4','5','6','7',
	'8',' ',':','#','@','\'','=','"',
	'9','0','/','s','t','u','v','w',
	'x','y',' ',']',',','%','_','>',
	'?','z','-','j','k','l','m','n',
	'o','p','q',' ','!','$','*',')',
	';','\\','r','&','a','b','c','d',
	'e','f','g','h',' ','[','.','<',
	'(','+','^','i',' ',' ',' ',' '
};

cropen(dev,flag)
{

	if (flag==0&&cr11.crstate==CLOSED) {
		cr11.crstate = WAITING;
		cr11.crnch = 0;
	} else {
		u.u_error = ENXIO;
		return;
	}
}

crclose(dev,flag)
{
	spl6();
	while (getc(&cr11.crin) >= 0);
	CRADDR->crcsr = 0;
	cr11.crstate = CLOSED;
	spl0();
}

crread()
{
	extern lbolt;
	register int c;

	do {
		spl6();
		while((c = getc(&cr11.crin))<0) {
			switch(cr11.crstate) {
			case CRERR:
				u.u_error = EIO;
				cr11.crstate = EOF;
			case EOF:
				cr11.crnch = 0;
				goto out;
			case WAITING:
				CRADDR->crcsr = IENABLE|RDRENB;
				sleep(&lbolt,CRPRI);
				break;
			case READING:
				if (CRADDR->crcsr & CARDDONE)
					CRADDR->crcsr =| IENABLE|RDRENB;
				sleep(&cr11.crin,CRPRI);
			}
		}
		spl0();
	} while (passc(asciicon(c)) >= 0);

out:
	spl0();
}

crint()
{
	register i;
	if (cr11.crstate == WAITING) {
		if(CRADDR->crcsr & ERROR)
			return;
		cr11.crstate = READING;
	}
	if(cr11.crstate == READING) {
		if (CRADDR->crcsr & ERROR) {
			cr11.crstate=(i=cr11.crnch)?(i==80?EOF:CRERR):WAITING;
		} else {

			if ((CRADDR->crcsr&CARDDONE) == 0) {
				cr11.crnch++;
				putc(CRADDR->crbuf2,&cr11.crin);
			} else {
				cr11.crnch=0;
				putc(NLCHAR,&cr11.crin);
				if (cr11.crin.cc < CRHIWAT)
					CRADDR->crcsr =| IENABLE|RDRENB;
			}
		}
		wakeup(&cr11.crin);
	}
}

asciicon(c)
{
	register c1, c2;

	c1 = c&0377;
	if (c1 == NLCHAR)
		return('\n');
	if (c1>=0200)
		c1 =- 040;
	c2 = c1;
	while ((c2 =- 040) >= 0)
		c1 =- 017;
	if(c1 > 0107)
		c1 = ' ';
	else c1 = asctab[c1];
	return(c1);
}
