/ low core
	.data			/remove this if for 11/40

br4 = 200
br5 = 240
br6 = 300
br7 = 340

. = 0^.
	br	1f
	4

/ trap vectors
	trap; br7+0		/ bus error
	trap; br7+1		/ illegal instruction
	trap; br7+2		/ bpt-trace trap
	trap; br7+3		/ iot trap
	trap; br7+4		/ power fail
	trap; br7+5		/ emulator trap
	trap; br7+6		/ system entry

. = 040^.
.globl	start
1:	jmp	start
.globl	dump
	jmp	*$dump

.globl	_crint
crin:
	jsr	r0,call; _crint

. = 060^.
	klin; br4
	klou; br4

. = 070^.
	pcin; br4
	pcou; br4

. = 100^.
	kwlp; br6
	kwlp; br6		/ do not canabalize... used by real time
				/ clock and profiling
. = 114^.
	trap; br7+7		/ memory system error



/ the following uses 60(8) words
/  hence must start no higher than 120(8)
.globl	call, trap
.globl	_clock
kwlp:
	jsr	r0,call; _clock


.globl	_tcintr
tcio:
	jsr	r0,call; _tcintr

.globl	_dmint
dmio:
	jsr	r0,call; _dmint

.globl	_rsintr
rsio:
	jsr	r0,call; _rsintr

.globl	_klrint
klin:
	jsr	r0,call; _klrint

.globl	_klxint
klou:
	jsr	r0,call; _klxint


.globl	_dhxint
dhout:
	jsr	r0,call; _dhxint

.globl	_pcrint
pcin:
	jsr	r0,call; _pcrint

. = 200^.
	lpou; br4

. = 204^.
	rsio; br5

. = 214^.
	tcio; br6

. = 224^.
	tmio; br5

. = 230^.
	crin; br6

. = 240^.
	dhin; br5+3		/ programed interupt used for dh
	trap; br7+10		/ floating point
	trap; br7+11		/ segmentation violation

. = 254^.
	dvio; br5

.globl	_lpint
lpou:
	jsr	r0,call; _lpint

.globl	_dvintr
dvio:
	jsr	r0,call; _dvintr

. = 300^.
	klin; br4+1
	klou; br4+1

. = 310^.
	dmio; br4

.globl	_pcpint
pcou:
	jsr	r0,call; _pcpint

.globl	_dhrint
dhin:
	jsr	r0,call; _dhrint

. = 330^.
	dhin; br5+0
	dhout; br5+0

. = 340^.
	dhin; br5+1
	dhout; br5+1

.globl	_tmintr
tmio:
	jsr	r0,call; _tmintr

. = . + 2

/	this code must end on a 10 byte boundary if the gcol
/	code is to be used... add filler if necessary

