#
/*
 * this logger reads from 0, writes expanded form on 1,
 * and writes selected messages on 2
 * these file handles are assumed to be associated with:
 *	0:	/dev/log	logger device within the system
 *	1:	/etc/logfile	permanent record of system log
 *	2:	/dev/cty	the console terminal
 *
 * the easiest way to do this is:
 *	/etc/logger < /dev/log >> /etc/logfile
 * in /etc/rc (where the cty is file handle 2)
 */
#include "/h/param.h"
#include "/h/iobuf.h"
main()
{
	extern fout;
	static struct iobuf ibuf;
	static long now, then;
	static char line[128];
	register code;
	register char *dp;
	register char *bp;

	fout = dup(1);
	ibuf.b_fildes = 0;
    for(;;) {
	code = getc(&ibuf);
	for (bp = line; *bp++ = getc(&ibuf); )
		if (bp >= &line + 1) bp--;
	bp[-2] = '\n';
	switch(code) {
	case LOG_LOG:
		if (getcsw() != 0)
			type(2, line);
	default:
		time (&now);
		if (now > then+300 || now < then) {
			dp = cdate(&now);
			then = now;
		} else dp = "";
		printf("%s|%d|%s", dp, code, line);
		flush();
	}
    }
}
